// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Settings for the action to activate a static image.
 */
public class StaticImageActivateScheduleActionSettings private constructor(builder: Builder) {
    /**
     * The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is unlimited and the image will remain until it is explicitly deactivated.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay. Default is 0 (no fade-in).
     */
    public val fadeIn: kotlin.Int? = builder.fadeIn
    /**
     * Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out starts when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).
     */
    public val fadeOut: kotlin.Int? = builder.fadeOut
    /**
     * The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified height. Leave blank to use the native height of the overlay.
     */
    public val height: kotlin.Int? = builder.height
    /**
     * The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels) than the input video.
     */
    public val image: aws.sdk.kotlin.services.medialive.model.InputLocation? = builder.image
    /**
     * Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right edge of the underlying video, then the overlay is cropped on the right.
     */
    public val imagex: kotlin.Int? = builder.imagex
    /**
     * Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the default) is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom edge of the underlying video, then the overlay is cropped on the bottom.
     */
    public val imagey: kotlin.Int? = builder.imagey
    /**
     * The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a different image. The layers are in Z order, which means that overlays with higher values of layer are inserted on top of overlays with lower values of layer. Default is 0.
     */
    public val layer: kotlin.Int? = builder.layer
    /**
     * Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
     */
    public val opacity: kotlin.Int? = builder.opacity
    /**
     * The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified width. Leave blank to use the native width of the overlay.
     */
    public val width: kotlin.Int? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.StaticImageActivateScheduleActionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StaticImageActivateScheduleActionSettings(")
        append("duration=$duration,")
        append("fadeIn=$fadeIn,")
        append("fadeOut=$fadeOut,")
        append("height=$height,")
        append("image=$image,")
        append("imagex=$imagex,")
        append("imagey=$imagey,")
        append("layer=$layer,")
        append("opacity=$opacity,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (fadeIn ?: 0)
        result = 31 * result + (fadeOut ?: 0)
        result = 31 * result + (height ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imagex ?: 0)
        result = 31 * result + (imagey ?: 0)
        result = 31 * result + (layer ?: 0)
        result = 31 * result + (opacity ?: 0)
        result = 31 * result + (width ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StaticImageActivateScheduleActionSettings

        if (duration != other.duration) return false
        if (fadeIn != other.fadeIn) return false
        if (fadeOut != other.fadeOut) return false
        if (height != other.height) return false
        if (image != other.image) return false
        if (imagex != other.imagex) return false
        if (imagey != other.imagey) return false
        if (layer != other.layer) return false
        if (opacity != other.opacity) return false
        if (width != other.width) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.StaticImageActivateScheduleActionSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is unlimited and the image will remain until it is explicitly deactivated.
         */
        public var duration: kotlin.Int? = null
        /**
         * The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay. Default is 0 (no fade-in).
         */
        public var fadeIn: kotlin.Int? = null
        /**
         * Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out starts when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).
         */
        public var fadeOut: kotlin.Int? = null
        /**
         * The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified height. Leave blank to use the native height of the overlay.
         */
        public var height: kotlin.Int? = null
        /**
         * The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels) than the input video.
         */
        public var image: aws.sdk.kotlin.services.medialive.model.InputLocation? = null
        /**
         * Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right edge of the underlying video, then the overlay is cropped on the right.
         */
        public var imagex: kotlin.Int? = null
        /**
         * Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the default) is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom edge of the underlying video, then the overlay is cropped on the bottom.
         */
        public var imagey: kotlin.Int? = null
        /**
         * The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a different image. The layers are in Z order, which means that overlays with higher values of layer are inserted on top of overlays with lower values of layer. Default is 0.
         */
        public var layer: kotlin.Int? = null
        /**
         * Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
         */
        public var opacity: kotlin.Int? = null
        /**
         * The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified width. Leave blank to use the native width of the overlay.
         */
        public var width: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.StaticImageActivateScheduleActionSettings) : this() {
            this.duration = x.duration
            this.fadeIn = x.fadeIn
            this.fadeOut = x.fadeOut
            this.height = x.height
            this.image = x.image
            this.imagex = x.imagex
            this.imagey = x.imagey
            this.layer = x.layer
            this.opacity = x.opacity
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.StaticImageActivateScheduleActionSettings = StaticImageActivateScheduleActionSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputLocation] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.medialive.model.InputLocation.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.medialive.model.InputLocation.invoke(block)
        }
    }
}
