// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Udp Output Settings
 */
public class UdpOutputSettings private constructor(builder: Builder) {
    /**
     * UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.
     */
    public val bufferMsec: kotlin.Int? = builder.bufferMsec
    /**
     * Udp Container Settings
     */
    public val containerSettings: aws.sdk.kotlin.services.medialive.model.UdpContainerSettings? = builder.containerSettings
    /**
     * Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
     */
    public val destination: aws.sdk.kotlin.services.medialive.model.OutputLocationRef? = builder.destination
    /**
     * Settings for enabling and adjusting Forward Error Correction on UDP outputs.
     */
    public val fecOutputSettings: aws.sdk.kotlin.services.medialive.model.FecOutputSettings? = builder.fecOutputSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.UdpOutputSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UdpOutputSettings(")
        append("bufferMsec=$bufferMsec,")
        append("containerSettings=$containerSettings,")
        append("destination=$destination,")
        append("fecOutputSettings=$fecOutputSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferMsec ?: 0
        result = 31 * result + (containerSettings?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (fecOutputSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UdpOutputSettings

        if (bufferMsec != other.bufferMsec) return false
        if (containerSettings != other.containerSettings) return false
        if (destination != other.destination) return false
        if (fecOutputSettings != other.fecOutputSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.UdpOutputSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.
         */
        public var bufferMsec: kotlin.Int? = null
        /**
         * Udp Container Settings
         */
        public var containerSettings: aws.sdk.kotlin.services.medialive.model.UdpContainerSettings? = null
        /**
         * Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
         */
        public var destination: aws.sdk.kotlin.services.medialive.model.OutputLocationRef? = null
        /**
         * Settings for enabling and adjusting Forward Error Correction on UDP outputs.
         */
        public var fecOutputSettings: aws.sdk.kotlin.services.medialive.model.FecOutputSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.UdpOutputSettings) : this() {
            this.bufferMsec = x.bufferMsec
            this.containerSettings = x.containerSettings
            this.destination = x.destination
            this.fecOutputSettings = x.fecOutputSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.UdpOutputSettings = UdpOutputSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.UdpContainerSettings] inside the given [block]
         */
        public fun containerSettings(block: aws.sdk.kotlin.services.medialive.model.UdpContainerSettings.Builder.() -> kotlin.Unit) {
            this.containerSettings = aws.sdk.kotlin.services.medialive.model.UdpContainerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.OutputLocationRef] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.medialive.model.OutputLocationRef.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.medialive.model.OutputLocationRef.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.FecOutputSettings] inside the given [block]
         */
        public fun fecOutputSettings(block: aws.sdk.kotlin.services.medialive.model.FecOutputSettings.Builder.() -> kotlin.Unit) {
            this.fecOutputSettings = aws.sdk.kotlin.services.medialive.model.FecOutputSettings.invoke(block)
        }
    }
}
