// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * A request to update an input.
 */
public class UpdateInputRequest private constructor(builder: Builder) {
    /**
     * Destination settings for PUSH type inputs.
     */
    public val destinations: List<InputDestinationRequest>? = builder.destinations
    /**
     * Settings for the devices.
     */
    public val inputDevices: List<InputDeviceRequest>? = builder.inputDevices
    /**
     * Unique ID of the input.
     */
    public val inputId: kotlin.String? = requireNotNull(builder.inputId) { "A non-null value must be provided for inputId" }
    /**
     * A list of security groups referenced by IDs to attach to the input.
     */
    public val inputSecurityGroups: List<String>? = builder.inputSecurityGroups
    /**
     * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
     */
    public val mediaConnectFlows: List<MediaConnectFlowRequest>? = builder.mediaConnectFlows
    /**
     * Name of the input.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
     */
    public val sources: List<InputSourceRequest>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.UpdateInputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInputRequest(")
        append("destinations=$destinations,")
        append("inputDevices=$inputDevices,")
        append("inputId=$inputId,")
        append("inputSecurityGroups=$inputSecurityGroups,")
        append("mediaConnectFlows=$mediaConnectFlows,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sources=$sources)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinations?.hashCode() ?: 0
        result = 31 * result + (inputDevices?.hashCode() ?: 0)
        result = 31 * result + (inputId?.hashCode() ?: 0)
        result = 31 * result + (inputSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (mediaConnectFlows?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateInputRequest

        if (destinations != other.destinations) return false
        if (inputDevices != other.inputDevices) return false
        if (inputId != other.inputId) return false
        if (inputSecurityGroups != other.inputSecurityGroups) return false
        if (mediaConnectFlows != other.mediaConnectFlows) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.UpdateInputRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Destination settings for PUSH type inputs.
         */
        public var destinations: List<InputDestinationRequest>? = null
        /**
         * Settings for the devices.
         */
        public var inputDevices: List<InputDeviceRequest>? = null
        /**
         * Unique ID of the input.
         */
        public var inputId: kotlin.String? = null
        /**
         * A list of security groups referenced by IDs to attach to the input.
         */
        public var inputSecurityGroups: List<String>? = null
        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         */
        public var mediaConnectFlows: List<MediaConnectFlowRequest>? = null
        /**
         * Name of the input.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         */
        public var sources: List<InputSourceRequest>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.UpdateInputRequest) : this() {
            this.destinations = x.destinations
            this.inputDevices = x.inputDevices
            this.inputId = x.inputId
            this.inputSecurityGroups = x.inputSecurityGroups
            this.mediaConnectFlows = x.mediaConnectFlows
            this.name = x.name
            this.roleArn = x.roleArn
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.UpdateInputRequest = UpdateInputRequest(this)
    }
}
