// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Video settings for this stream.
 */
public class VideoDescription private constructor(builder: Builder) {
    /**
     * Video codec settings.
     */
    public val codecSettings: aws.sdk.kotlin.services.medialive.model.VideoCodecSettings? = builder.codecSettings
    /**
     * Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
     */
    public val height: kotlin.Int? = builder.height
    /**
     * The name of this VideoDescription. Outputs will use this name to uniquely identify this Description. Description names should be unique within this Live Event.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and does not include the AFD values in the output
     */
    public val respondToAfd: aws.sdk.kotlin.services.medialive.model.VideoDescriptionRespondToAfd? = builder.respondToAfd
    /**
     * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
     */
    public val scalingBehavior: aws.sdk.kotlin.services.medialive.model.VideoDescriptionScalingBehavior? = builder.scalingBehavior
    /**
     * Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.
     */
    public val sharpness: kotlin.Int? = builder.sharpness
    /**
     * Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
     */
    public val width: kotlin.Int? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.VideoDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoDescription(")
        append("codecSettings=$codecSettings,")
        append("height=$height,")
        append("name=$name,")
        append("respondToAfd=$respondToAfd,")
        append("scalingBehavior=$scalingBehavior,")
        append("sharpness=$sharpness,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codecSettings?.hashCode() ?: 0
        result = 31 * result + (height ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (respondToAfd?.hashCode() ?: 0)
        result = 31 * result + (scalingBehavior?.hashCode() ?: 0)
        result = 31 * result + (sharpness ?: 0)
        result = 31 * result + (width ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoDescription

        if (codecSettings != other.codecSettings) return false
        if (height != other.height) return false
        if (name != other.name) return false
        if (respondToAfd != other.respondToAfd) return false
        if (scalingBehavior != other.scalingBehavior) return false
        if (sharpness != other.sharpness) return false
        if (width != other.width) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.VideoDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Video codec settings.
         */
        public var codecSettings: aws.sdk.kotlin.services.medialive.model.VideoCodecSettings? = null
        /**
         * Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
         */
        public var height: kotlin.Int? = null
        /**
         * The name of this VideoDescription. Outputs will use this name to uniquely identify this Description. Description names should be unique within this Live Event.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and does not include the AFD values in the output
         */
        public var respondToAfd: aws.sdk.kotlin.services.medialive.model.VideoDescriptionRespondToAfd? = null
        /**
         * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
         */
        public var scalingBehavior: aws.sdk.kotlin.services.medialive.model.VideoDescriptionScalingBehavior? = null
        /**
         * Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.
         */
        public var sharpness: kotlin.Int? = null
        /**
         * Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
         */
        public var width: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.VideoDescription) : this() {
            this.codecSettings = x.codecSettings
            this.height = x.height
            this.name = x.name
            this.respondToAfd = x.respondToAfd
            this.scalingBehavior = x.scalingBehavior
            this.sharpness = x.sharpness
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.VideoDescription = VideoDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.VideoCodecSettings] inside the given [block]
         */
        public fun codecSettings(block: aws.sdk.kotlin.services.medialive.model.VideoCodecSettings.Builder.() -> kotlin.Unit) {
            this.codecSettings = aws.sdk.kotlin.services.medialive.model.VideoCodecSettings.invoke(block)
        }
    }
}
