// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * The properties for a private VPC Output When this property is specified, the output egress addresses will be created in a user specified VPC
 */
public class VpcOutputSettings private constructor(builder: Builder) {
    /**
     * List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels
     */
    public val publicAddressAllocationIds: List<String>? = builder.publicAddressAllocationIds
    /**
     * A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.VpcOutputSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcOutputSettings(")
        append("publicAddressAllocationIds=$publicAddressAllocationIds,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = publicAddressAllocationIds?.hashCode() ?: 0
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcOutputSettings

        if (publicAddressAllocationIds != other.publicAddressAllocationIds) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.VpcOutputSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels
         */
        public var publicAddressAllocationIds: List<String>? = null
        /**
         * A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.VpcOutputSettings) : this() {
            this.publicAddressAllocationIds = x.publicAddressAllocationIds
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.VpcOutputSettings = VpcOutputSettings(this)
    }
}
