// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.paginators

import aws.sdk.kotlin.services.medialive.MediaLiveClient
import aws.sdk.kotlin.services.medialive.model.ChannelSummary
import aws.sdk.kotlin.services.medialive.model.DescribeScheduleRequest
import aws.sdk.kotlin.services.medialive.model.DescribeScheduleResponse
import aws.sdk.kotlin.services.medialive.model.Input
import aws.sdk.kotlin.services.medialive.model.InputDeviceSummary
import aws.sdk.kotlin.services.medialive.model.InputSecurityGroup
import aws.sdk.kotlin.services.medialive.model.ListChannelsRequest
import aws.sdk.kotlin.services.medialive.model.ListChannelsResponse
import aws.sdk.kotlin.services.medialive.model.ListInputDeviceTransfersRequest
import aws.sdk.kotlin.services.medialive.model.ListInputDeviceTransfersResponse
import aws.sdk.kotlin.services.medialive.model.ListInputDevicesRequest
import aws.sdk.kotlin.services.medialive.model.ListInputDevicesResponse
import aws.sdk.kotlin.services.medialive.model.ListInputSecurityGroupsRequest
import aws.sdk.kotlin.services.medialive.model.ListInputSecurityGroupsResponse
import aws.sdk.kotlin.services.medialive.model.ListInputsRequest
import aws.sdk.kotlin.services.medialive.model.ListInputsResponse
import aws.sdk.kotlin.services.medialive.model.ListMultiplexProgramsRequest
import aws.sdk.kotlin.services.medialive.model.ListMultiplexProgramsResponse
import aws.sdk.kotlin.services.medialive.model.ListMultiplexesRequest
import aws.sdk.kotlin.services.medialive.model.ListMultiplexesResponse
import aws.sdk.kotlin.services.medialive.model.ListOfferingsRequest
import aws.sdk.kotlin.services.medialive.model.ListOfferingsResponse
import aws.sdk.kotlin.services.medialive.model.ListReservationsRequest
import aws.sdk.kotlin.services.medialive.model.ListReservationsResponse
import aws.sdk.kotlin.services.medialive.model.MultiplexProgramSummary
import aws.sdk.kotlin.services.medialive.model.MultiplexSummary
import aws.sdk.kotlin.services.medialive.model.Offering
import aws.sdk.kotlin.services.medialive.model.Reservation
import aws.sdk.kotlin.services.medialive.model.ScheduleAction
import aws.sdk.kotlin.services.medialive.model.TransferringInputDeviceSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeScheduleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScheduleRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduleResponse]
 */
public fun MediaLiveClient.describeSchedulePaginated(initialRequest: DescribeScheduleRequest): Flow<DescribeScheduleResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSchedulePaginated.describeSchedule(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScheduleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduleResponse]
 */
public fun MediaLiveClient.describeSchedulePaginated(block: DescribeScheduleRequest.Builder.() -> Unit): Flow<DescribeScheduleResponse> =
    describeSchedulePaginated(DescribeScheduleRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSchedulePaginated]
 * to access the nested member [ScheduleAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduleAction]
 */
@JvmName("describeScheduleResponseScheduleAction")
public fun Flow<DescribeScheduleResponse>.scheduleActions(): Flow<ScheduleAction> =
    transform() { response ->
        response.scheduleActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaLiveClient.listChannelsPaginated(initialRequest: ListChannelsRequest): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaLiveClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelsPaginated]
 * to access the nested member [ChannelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChannelSummary]
 */
@JvmName("listChannelsResponseChannelSummary")
public fun Flow<ListChannelsResponse>.channels(): Flow<ChannelSummary> =
    transform() { response ->
        response.channels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInputDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInputDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputDevicesResponse]
 */
public fun MediaLiveClient.listInputDevicesPaginated(initialRequest: ListInputDevicesRequest): Flow<ListInputDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInputDevicesPaginated.listInputDevices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInputDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputDevicesResponse]
 */
public fun MediaLiveClient.listInputDevicesPaginated(block: ListInputDevicesRequest.Builder.() -> Unit): Flow<ListInputDevicesResponse> =
    listInputDevicesPaginated(ListInputDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInputDevicesPaginated]
 * to access the nested member [InputDeviceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InputDeviceSummary]
 */
@JvmName("listInputDevicesResponseInputDeviceSummary")
public fun Flow<ListInputDevicesResponse>.inputDevices(): Flow<InputDeviceSummary> =
    transform() { response ->
        response.inputDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInputDeviceTransfersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInputDeviceTransfersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputDeviceTransfersResponse]
 */
public fun MediaLiveClient.listInputDeviceTransfersPaginated(initialRequest: ListInputDeviceTransfersRequest): Flow<ListInputDeviceTransfersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInputDeviceTransfersPaginated.listInputDeviceTransfers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInputDeviceTransfersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputDeviceTransfersResponse]
 */
public fun MediaLiveClient.listInputDeviceTransfersPaginated(block: ListInputDeviceTransfersRequest.Builder.() -> Unit): Flow<ListInputDeviceTransfersResponse> =
    listInputDeviceTransfersPaginated(ListInputDeviceTransfersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInputDeviceTransfersPaginated]
 * to access the nested member [TransferringInputDeviceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransferringInputDeviceSummary]
 */
@JvmName("listInputDeviceTransfersResponseTransferringInputDeviceSummary")
public fun Flow<ListInputDeviceTransfersResponse>.inputDeviceTransfers(): Flow<TransferringInputDeviceSummary> =
    transform() { response ->
        response.inputDeviceTransfers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInputsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputsResponse]
 */
public fun MediaLiveClient.listInputsPaginated(initialRequest: ListInputsRequest): Flow<ListInputsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInputsPaginated.listInputs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputsResponse]
 */
public fun MediaLiveClient.listInputsPaginated(block: ListInputsRequest.Builder.() -> Unit): Flow<ListInputsResponse> =
    listInputsPaginated(ListInputsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInputsPaginated]
 * to access the nested member [Input]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Input]
 */
@JvmName("listInputsResponseInput")
public fun Flow<ListInputsResponse>.inputs(): Flow<Input> =
    transform() { response ->
        response.inputs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInputSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInputSecurityGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputSecurityGroupsResponse]
 */
public fun MediaLiveClient.listInputSecurityGroupsPaginated(initialRequest: ListInputSecurityGroupsRequest): Flow<ListInputSecurityGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInputSecurityGroupsPaginated.listInputSecurityGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInputSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInputSecurityGroupsResponse]
 */
public fun MediaLiveClient.listInputSecurityGroupsPaginated(block: ListInputSecurityGroupsRequest.Builder.() -> Unit): Flow<ListInputSecurityGroupsResponse> =
    listInputSecurityGroupsPaginated(ListInputSecurityGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInputSecurityGroupsPaginated]
 * to access the nested member [InputSecurityGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InputSecurityGroup]
 */
@JvmName("listInputSecurityGroupsResponseInputSecurityGroup")
public fun Flow<ListInputSecurityGroupsResponse>.inputSecurityGroups(): Flow<InputSecurityGroup> =
    transform() { response ->
        response.inputSecurityGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMultiplexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMultiplexesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiplexesResponse]
 */
public fun MediaLiveClient.listMultiplexesPaginated(initialRequest: ListMultiplexesRequest): Flow<ListMultiplexesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMultiplexesPaginated.listMultiplexes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMultiplexesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiplexesResponse]
 */
public fun MediaLiveClient.listMultiplexesPaginated(block: ListMultiplexesRequest.Builder.() -> Unit): Flow<ListMultiplexesResponse> =
    listMultiplexesPaginated(ListMultiplexesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMultiplexesPaginated]
 * to access the nested member [MultiplexSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MultiplexSummary]
 */
@JvmName("listMultiplexesResponseMultiplexSummary")
public fun Flow<ListMultiplexesResponse>.multiplexes(): Flow<MultiplexSummary> =
    transform() { response ->
        response.multiplexes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMultiplexProgramsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMultiplexProgramsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiplexProgramsResponse]
 */
public fun MediaLiveClient.listMultiplexProgramsPaginated(initialRequest: ListMultiplexProgramsRequest): Flow<ListMultiplexProgramsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMultiplexProgramsPaginated.listMultiplexPrograms(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMultiplexProgramsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiplexProgramsResponse]
 */
public fun MediaLiveClient.listMultiplexProgramsPaginated(block: ListMultiplexProgramsRequest.Builder.() -> Unit): Flow<ListMultiplexProgramsResponse> =
    listMultiplexProgramsPaginated(ListMultiplexProgramsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMultiplexProgramsPaginated]
 * to access the nested member [MultiplexProgramSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MultiplexProgramSummary]
 */
@JvmName("listMultiplexProgramsResponseMultiplexProgramSummary")
public fun Flow<ListMultiplexProgramsResponse>.multiplexPrograms(): Flow<MultiplexProgramSummary> =
    transform() { response ->
        response.multiplexPrograms?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun MediaLiveClient.listOfferingsPaginated(initialRequest: ListOfferingsRequest): Flow<ListOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOfferingsPaginated.listOfferings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun MediaLiveClient.listOfferingsPaginated(block: ListOfferingsRequest.Builder.() -> Unit): Flow<ListOfferingsResponse> =
    listOfferingsPaginated(ListOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOfferingsPaginated]
 * to access the nested member [Offering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Offering]
 */
@JvmName("listOfferingsResponseOffering")
public fun Flow<ListOfferingsResponse>.offerings(): Flow<Offering> =
    transform() { response ->
        response.offerings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReservationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReservationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReservationsResponse]
 */
public fun MediaLiveClient.listReservationsPaginated(initialRequest: ListReservationsRequest): Flow<ListReservationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReservationsPaginated.listReservations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReservationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReservationsResponse]
 */
public fun MediaLiveClient.listReservationsPaginated(block: ListReservationsRequest.Builder.() -> Unit): Flow<ListReservationsResponse> =
    listReservationsPaginated(ListReservationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReservationsPaginated]
 * to access the nested member [Reservation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Reservation]
 */
@JvmName("listReservationsResponseReservation")
public fun Flow<ListReservationsResponse>.reservations(): Flow<Reservation> =
    transform() { response ->
        response.reservations?.forEach {
            emit(it)
        }
    }
