// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.BatchFailedResultModel
import aws.sdk.kotlin.services.medialive.model.BatchStartResponse
import aws.sdk.kotlin.services.medialive.model.BatchSuccessfulResultModel
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchStartOperationDeserializer: HttpDeserialize<BatchStartResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchStartResponse {
        if (!response.status.isSuccess()) {
            throwBatchStartError(context, response)
        }
        val builder = BatchStartResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchStartOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchStartError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchStartOperationBody(builder: BatchStartResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failed"))
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successful"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchFailedResultModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchFailedResultModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchSuccessfulResultModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchSuccessfulResultModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
