// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.services.medialive.model.CdiInputSpecification
import aws.sdk.kotlin.services.medialive.model.ChannelClass
import aws.sdk.kotlin.services.medialive.model.CreateChannelRequest
import aws.sdk.kotlin.services.medialive.model.EncoderSettings
import aws.sdk.kotlin.services.medialive.model.InputAttachment
import aws.sdk.kotlin.services.medialive.model.InputSpecification
import aws.sdk.kotlin.services.medialive.model.LogLevel
import aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings
import aws.sdk.kotlin.services.medialive.model.OutputDestination
import aws.sdk.kotlin.services.medialive.model.VpcOutputSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateChannelOperationSerializer: HttpSerialize<CreateChannelRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateChannelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/prod/channels"
        }

        val payload = serializeCreateChannelOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateChannelOperationBody(context: ExecutionContext, input: CreateChannelRequest): ByteArray {
    val serializer = JsonSerializer()
    val CDIINPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cdiInputSpecification"))
    val CHANNELCLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelClass"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinations"))
    val ENCODERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encoderSettings"))
    val INPUTATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputAttachments"))
    val INPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputSpecification"))
    val LOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logLevel"))
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val RESERVED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reserved"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpc"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CDIINPUTSPECIFICATION_DESCRIPTOR)
        field(CHANNELCLASS_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ENCODERSETTINGS_DESCRIPTOR)
        field(INPUTATTACHMENTS_DESCRIPTOR)
        field(INPUTSPECIFICATION_DESCRIPTOR)
        field(LOGLEVEL_DESCRIPTOR)
        field(MAINTENANCE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(RESERVED_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPC_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cdiInputSpecification?.let { field(CDIINPUTSPECIFICATION_DESCRIPTOR, it, ::serializeCdiInputSpecificationDocument) }
        input.channelClass?.let { field(CHANNELCLASS_DESCRIPTOR, it.value) }
        if (input.destinations != null) {
            listField(DESTINATIONS_DESCRIPTOR) {
                for (el0 in input.destinations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOutputDestinationDocument))
                }
            }
        }
        input.encoderSettings?.let { field(ENCODERSETTINGS_DESCRIPTOR, it, ::serializeEncoderSettingsDocument) }
        if (input.inputAttachments != null) {
            listField(INPUTATTACHMENTS_DESCRIPTOR) {
                for (el0 in input.inputAttachments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputAttachmentDocument))
                }
            }
        }
        input.inputSpecification?.let { field(INPUTSPECIFICATION_DESCRIPTOR, it, ::serializeInputSpecificationDocument) }
        input.logLevel?.let { field(LOGLEVEL_DESCRIPTOR, it.value) }
        input.maintenance?.let { field(MAINTENANCE_DESCRIPTOR, it, ::serializeMaintenanceCreateSettingsDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.requestId?.let { field(REQUESTID_DESCRIPTOR, it) } ?: field(REQUESTID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.reserved?.let { field(RESERVED_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.vpc?.let { field(VPC_DESCRIPTOR, it, ::serializeVpcOutputSettingsDocument) }
    }
    return serializer.toByteArray()
}
