// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.services.medialive.model.CreateMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.MultiplexSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateMultiplexOperationSerializer: HttpSerialize<CreateMultiplexRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateMultiplexRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/prod/multiplexes"
        }

        val payload = serializeCreateMultiplexOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateMultiplexOperationBody(context: ExecutionContext, input: CreateMultiplexRequest): ByteArray {
    val serializer = JsonSerializer()
    val AVAILABILITYZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("availabilityZones"))
    val MULTIPLEXSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multiplexSettings"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONES_DESCRIPTOR)
        field(MULTIPLEXSETTINGS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.availabilityZones != null) {
            listField(AVAILABILITYZONES_DESCRIPTOR) {
                for (el0 in input.availabilityZones) {
                    serializeString(el0)
                }
            }
        }
        input.multiplexSettings?.let { field(MULTIPLEXSETTINGS_DESCRIPTOR, it, ::serializeMultiplexSettingsDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.requestId?.let { field(REQUESTID_DESCRIPTOR, it) } ?: field(REQUESTID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
