// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.sdk.kotlin.services.medialive.model.MultiplexOutputDestination
import aws.sdk.kotlin.services.medialive.model.MultiplexSettings
import aws.sdk.kotlin.services.medialive.model.MultiplexState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteMultiplexOperationDeserializer: HttpDeserialize<DeleteMultiplexResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteMultiplexResponse {
        if (!response.status.isSuccess()) {
            throwDeleteMultiplexError(context, response)
        }
        val builder = DeleteMultiplexResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteMultiplexOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteMultiplexError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteMultiplexOperationBody(builder: DeleteMultiplexResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AVAILABILITYZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("availabilityZones"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinations"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MULTIPLEXSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multiplexSettings"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PIPELINESRUNNINGCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("pipelinesRunningCount"))
    val PROGRAMCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("programCount"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("state"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AVAILABILITYZONES_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MULTIPLEXSETTINGS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PIPELINESRUNNINGCOUNT_DESCRIPTOR)
        field(PROGRAMCOUNT_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AVAILABILITYZONES_DESCRIPTOR.index -> builder.availabilityZones =
                    deserializer.deserializeList(AVAILABILITYZONES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<MultiplexOutputDestination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMultiplexOutputDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MULTIPLEXSETTINGS_DESCRIPTOR.index -> builder.multiplexSettings = deserializeMultiplexSettingsDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PIPELINESRUNNINGCOUNT_DESCRIPTOR.index -> builder.pipelinesRunningCount = deserializeInt()
                PROGRAMCOUNT_DESCRIPTOR.index -> builder.programCount = deserializeInt()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { MultiplexState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
