// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexProgramResponse
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.sdk.kotlin.services.medialive.model.MultiplexProgramPacketIdentifiersMap
import aws.sdk.kotlin.services.medialive.model.MultiplexProgramPipelineDetail
import aws.sdk.kotlin.services.medialive.model.MultiplexProgramSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteMultiplexProgramOperationDeserializer: HttpDeserialize<DeleteMultiplexProgramResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteMultiplexProgramResponse {
        if (!response.status.isSuccess()) {
            throwDeleteMultiplexProgramError(context, response)
        }
        val builder = DeleteMultiplexProgramResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteMultiplexProgramOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteMultiplexProgramError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteMultiplexProgramOperationBody(builder: DeleteMultiplexProgramResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val MULTIPLEXPROGRAMSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multiplexProgramSettings"))
    val PACKETIDENTIFIERSMAP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("packetIdentifiersMap"))
    val PIPELINEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pipelineDetails"))
    val PROGRAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("programName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELID_DESCRIPTOR)
        field(MULTIPLEXPROGRAMSETTINGS_DESCRIPTOR)
        field(PACKETIDENTIFIERSMAP_DESCRIPTOR)
        field(PIPELINEDETAILS_DESCRIPTOR)
        field(PROGRAMNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                MULTIPLEXPROGRAMSETTINGS_DESCRIPTOR.index -> builder.multiplexProgramSettings = deserializeMultiplexProgramSettingsDocument(deserializer)
                PACKETIDENTIFIERSMAP_DESCRIPTOR.index -> builder.packetIdentifiersMap = deserializeMultiplexProgramPacketIdentifiersMapDocument(deserializer)
                PIPELINEDETAILS_DESCRIPTOR.index -> builder.pipelineDetails =
                    deserializer.deserializeList(PIPELINEDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<MultiplexProgramPipelineDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMultiplexProgramPipelineDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROGRAMNAME_DESCRIPTOR.index -> builder.programName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
