// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.ContentType
import aws.sdk.kotlin.services.medialive.model.DescribeInputDeviceThumbnailResponse
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeInputDeviceThumbnailOperationDeserializer: HttpDeserialize<DescribeInputDeviceThumbnailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInputDeviceThumbnailResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInputDeviceThumbnailError(context, response)
        }
        val builder = DescribeInputDeviceThumbnailResponse.Builder()

        builder.contentLength = response.headers["Content-Length"]?.toLong()
        builder.contentType = response.headers["Content-Type"]?.let { ContentType.fromValue(it) }
        builder.eTag = response.headers["ETag"]
        builder.lastModified = response.headers["Last-Modified"]?.let { Instant.fromRfc5322(it) }

        builder.body = response.body.toByteStream()

        return builder.build()
    }
}

private suspend fun throwDescribeInputDeviceThumbnailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
