// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.DescribeInputSecurityGroupResponse
import aws.sdk.kotlin.services.medialive.model.InputSecurityGroupState
import aws.sdk.kotlin.services.medialive.model.InputWhitelistRule
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeInputSecurityGroupOperationDeserializer: HttpDeserialize<DescribeInputSecurityGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInputSecurityGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInputSecurityGroupError(context, response)
        }
        val builder = DescribeInputSecurityGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInputSecurityGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeInputSecurityGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInputSecurityGroupOperationBody(builder: DescribeInputSecurityGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val INPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputs"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("state"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val WHITELISTRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("whitelistRules"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INPUTS_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(WHITELISTRULES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INPUTS_DESCRIPTOR.index -> builder.inputs =
                    deserializer.deserializeList(INPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { InputSecurityGroupState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                WHITELISTRULES_DESCRIPTOR.index -> builder.whitelistRules =
                    deserializer.deserializeList(WHITELISTRULES_DESCRIPTOR) {
                        val col0 = mutableListOf<InputWhitelistRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputWhitelistRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
