// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.DescribeReservationResponse
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.sdk.kotlin.services.medialive.model.OfferingDurationUnits
import aws.sdk.kotlin.services.medialive.model.OfferingType
import aws.sdk.kotlin.services.medialive.model.RenewalSettings
import aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification
import aws.sdk.kotlin.services.medialive.model.ReservationState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeReservationOperationDeserializer: HttpDeserialize<DescribeReservationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeReservationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeReservationError(context, response)
        }
        val builder = DescribeReservationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReservationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeReservationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReservationOperationBody(builder: DescribeReservationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val COUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("count"))
    val CURRENCYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currencyCode"))
    val DURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("duration"))
    val DURATIONUNITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("durationUnits"))
    val END_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("end"))
    val FIXEDPRICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("fixedPrice"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OFFERINGDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("offeringDescription"))
    val OFFERINGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("offeringId"))
    val OFFERINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("offeringType"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val RENEWALSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("renewalSettings"))
    val RESERVATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reservationId"))
    val RESOURCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceSpecification"))
    val START_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("start"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("state"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USAGEPRICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("usagePrice"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COUNT_DESCRIPTOR)
        field(CURRENCYCODE_DESCRIPTOR)
        field(DURATION_DESCRIPTOR)
        field(DURATIONUNITS_DESCRIPTOR)
        field(END_DESCRIPTOR)
        field(FIXEDPRICE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OFFERINGDESCRIPTION_DESCRIPTOR)
        field(OFFERINGID_DESCRIPTOR)
        field(OFFERINGTYPE_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(RENEWALSETTINGS_DESCRIPTOR)
        field(RESERVATIONID_DESCRIPTOR)
        field(RESOURCESPECIFICATION_DESCRIPTOR)
        field(START_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USAGEPRICE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COUNT_DESCRIPTOR.index -> builder.count = deserializeInt()
                CURRENCYCODE_DESCRIPTOR.index -> builder.currencyCode = deserializeString()
                DURATION_DESCRIPTOR.index -> builder.duration = deserializeInt()
                DURATIONUNITS_DESCRIPTOR.index -> builder.durationUnits = deserializeString().let { OfferingDurationUnits.fromValue(it) }
                END_DESCRIPTOR.index -> builder.end = deserializeString()
                FIXEDPRICE_DESCRIPTOR.index -> builder.fixedPrice = deserializeDouble()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OFFERINGDESCRIPTION_DESCRIPTOR.index -> builder.offeringDescription = deserializeString()
                OFFERINGID_DESCRIPTOR.index -> builder.offeringId = deserializeString()
                OFFERINGTYPE_DESCRIPTOR.index -> builder.offeringType = deserializeString().let { OfferingType.fromValue(it) }
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                RENEWALSETTINGS_DESCRIPTOR.index -> builder.renewalSettings = deserializeRenewalSettingsDocument(deserializer)
                RESERVATIONID_DESCRIPTOR.index -> builder.reservationId = deserializeString()
                RESOURCESPECIFICATION_DESCRIPTOR.index -> builder.resourceSpecification = deserializeReservationResourceSpecificationDocument(deserializer)
                START_DESCRIPTOR.index -> builder.start = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ReservationState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USAGEPRICE_DESCRIPTOR.index -> builder.usagePrice = deserializeDouble()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
