// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.CdiInputSpecification
import aws.sdk.kotlin.services.medialive.model.ChannelClass
import aws.sdk.kotlin.services.medialive.model.ChannelEgressEndpoint
import aws.sdk.kotlin.services.medialive.model.ChannelState
import aws.sdk.kotlin.services.medialive.model.EncoderSettings
import aws.sdk.kotlin.services.medialive.model.InputAttachment
import aws.sdk.kotlin.services.medialive.model.InputSpecification
import aws.sdk.kotlin.services.medialive.model.LogLevel
import aws.sdk.kotlin.services.medialive.model.MaintenanceStatus
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.sdk.kotlin.services.medialive.model.OutputDestination
import aws.sdk.kotlin.services.medialive.model.PipelineDetail
import aws.sdk.kotlin.services.medialive.model.StartChannelResponse
import aws.sdk.kotlin.services.medialive.model.VpcOutputSettingsDescription
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartChannelOperationDeserializer: HttpDeserialize<StartChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartChannelResponse {
        if (!response.status.isSuccess()) {
            throwStartChannelError(context, response)
        }
        val builder = StartChannelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartChannelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartChannelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartChannelOperationBody(builder: StartChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CDIINPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cdiInputSpecification"))
    val CHANNELCLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelClass"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinations"))
    val EGRESSENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("egressEndpoints"))
    val ENCODERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encoderSettings"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val INPUTATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputAttachments"))
    val INPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputSpecification"))
    val LOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logLevel"))
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PIPELINEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("pipelineDetails"))
    val PIPELINESRUNNINGCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("pipelinesRunningCount"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("state"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpc"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CDIINPUTSPECIFICATION_DESCRIPTOR)
        field(CHANNELCLASS_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(EGRESSENDPOINTS_DESCRIPTOR)
        field(ENCODERSETTINGS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INPUTATTACHMENTS_DESCRIPTOR)
        field(INPUTSPECIFICATION_DESCRIPTOR)
        field(LOGLEVEL_DESCRIPTOR)
        field(MAINTENANCE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PIPELINEDETAILS_DESCRIPTOR)
        field(PIPELINESRUNNINGCOUNT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPC_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CDIINPUTSPECIFICATION_DESCRIPTOR.index -> builder.cdiInputSpecification = deserializeCdiInputSpecificationDocument(deserializer)
                CHANNELCLASS_DESCRIPTOR.index -> builder.channelClass = deserializeString().let { ChannelClass.fromValue(it) }
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<OutputDestination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutputDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EGRESSENDPOINTS_DESCRIPTOR.index -> builder.egressEndpoints =
                    deserializer.deserializeList(EGRESSENDPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ChannelEgressEndpoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChannelEgressEndpointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENCODERSETTINGS_DESCRIPTOR.index -> builder.encoderSettings = deserializeEncoderSettingsDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INPUTATTACHMENTS_DESCRIPTOR.index -> builder.inputAttachments =
                    deserializer.deserializeList(INPUTATTACHMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<InputAttachment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputAttachmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INPUTSPECIFICATION_DESCRIPTOR.index -> builder.inputSpecification = deserializeInputSpecificationDocument(deserializer)
                LOGLEVEL_DESCRIPTOR.index -> builder.logLevel = deserializeString().let { LogLevel.fromValue(it) }
                MAINTENANCE_DESCRIPTOR.index -> builder.maintenance = deserializeMaintenanceStatusDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PIPELINEDETAILS_DESCRIPTOR.index -> builder.pipelineDetails =
                    deserializer.deserializeList(PIPELINEDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<PipelineDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePipelineDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PIPELINESRUNNINGCOUNT_DESCRIPTOR.index -> builder.pipelinesRunningCount = deserializeInt()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ChannelState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPC_DESCRIPTOR.index -> builder.vpc = deserializeVpcOutputSettingsDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
