// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.services.medialive.model.TransferInputDeviceRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TransferInputDeviceOperationSerializer: HttpSerialize<TransferInputDeviceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TransferInputDeviceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "prod",
                "inputDevices",
                "${input.inputDeviceId}".encodeLabel(),
                "transfer",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeTransferInputDeviceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeTransferInputDeviceOperationBody(context: ExecutionContext, input: TransferInputDeviceRequest): ByteArray {
    val serializer = JsonSerializer()
    val TARGETCUSTOMERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetCustomerId"))
    val TARGETREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetRegion"))
    val TRANSFERMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("transferMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TARGETCUSTOMERID_DESCRIPTOR)
        field(TARGETREGION_DESCRIPTOR)
        field(TRANSFERMESSAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.targetCustomerId?.let { field(TARGETCUSTOMERID_DESCRIPTOR, it) }
        input.targetRegion?.let { field(TARGETREGION_DESCRIPTOR, it) }
        input.transferMessage?.let { field(TRANSFERMESSAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
