// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.services.medialive.model.CdiInputSpecification
import aws.sdk.kotlin.services.medialive.model.EncoderSettings
import aws.sdk.kotlin.services.medialive.model.InputAttachment
import aws.sdk.kotlin.services.medialive.model.InputSpecification
import aws.sdk.kotlin.services.medialive.model.LogLevel
import aws.sdk.kotlin.services.medialive.model.MaintenanceUpdateSettings
import aws.sdk.kotlin.services.medialive.model.OutputDestination
import aws.sdk.kotlin.services.medialive.model.UpdateChannelRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateChannelOperationSerializer: HttpSerialize<UpdateChannelRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateChannelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "prod",
                "channels",
                "${input.channelId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateChannelOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateChannelOperationBody(context: ExecutionContext, input: UpdateChannelRequest): ByteArray {
    val serializer = JsonSerializer()
    val CDIINPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cdiInputSpecification"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinations"))
    val ENCODERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encoderSettings"))
    val INPUTATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputAttachments"))
    val INPUTSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputSpecification"))
    val LOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logLevel"))
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CDIINPUTSPECIFICATION_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ENCODERSETTINGS_DESCRIPTOR)
        field(INPUTATTACHMENTS_DESCRIPTOR)
        field(INPUTSPECIFICATION_DESCRIPTOR)
        field(LOGLEVEL_DESCRIPTOR)
        field(MAINTENANCE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cdiInputSpecification?.let { field(CDIINPUTSPECIFICATION_DESCRIPTOR, it, ::serializeCdiInputSpecificationDocument) }
        if (input.destinations != null) {
            listField(DESTINATIONS_DESCRIPTOR) {
                for (el0 in input.destinations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOutputDestinationDocument))
                }
            }
        }
        input.encoderSettings?.let { field(ENCODERSETTINGS_DESCRIPTOR, it, ::serializeEncoderSettingsDocument) }
        if (input.inputAttachments != null) {
            listField(INPUTATTACHMENTS_DESCRIPTOR) {
                for (el0 in input.inputAttachments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputAttachmentDocument))
                }
            }
        }
        input.inputSpecification?.let { field(INPUTSPECIFICATION_DESCRIPTOR, it, ::serializeInputSpecificationDocument) }
        input.logLevel?.let { field(LOGLEVEL_DESCRIPTOR, it.value) }
        input.maintenance?.let { field(MAINTENANCE_DESCRIPTOR, it, ::serializeMaintenanceUpdateSettingsDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
