// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.services.medialive.model.InputDestinationRequest
import aws.sdk.kotlin.services.medialive.model.InputDeviceRequest
import aws.sdk.kotlin.services.medialive.model.InputSourceRequest
import aws.sdk.kotlin.services.medialive.model.MediaConnectFlowRequest
import aws.sdk.kotlin.services.medialive.model.UpdateInputRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateInputOperationSerializer: HttpSerialize<UpdateInputRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateInputRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "prod",
                "inputs",
                "${input.inputId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateInputOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateInputOperationBody(context: ExecutionContext, input: UpdateInputRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinations"))
    val INPUTDEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputDevices"))
    val INPUTSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputSecurityGroups"))
    val MEDIACONNECTFLOWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mediaConnectFlows"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONS_DESCRIPTOR)
        field(INPUTDEVICES_DESCRIPTOR)
        field(INPUTSECURITYGROUPS_DESCRIPTOR)
        field(MEDIACONNECTFLOWS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.destinations != null) {
            listField(DESTINATIONS_DESCRIPTOR) {
                for (el0 in input.destinations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputDestinationRequestDocument))
                }
            }
        }
        if (input.inputDevices != null) {
            listField(INPUTDEVICES_DESCRIPTOR) {
                for (el0 in input.inputDevices) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputDeviceRequestDocument))
                }
            }
        }
        if (input.inputSecurityGroups != null) {
            listField(INPUTSECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.inputSecurityGroups) {
                    serializeString(el0)
                }
            }
        }
        if (input.mediaConnectFlows != null) {
            listField(MEDIACONNECTFLOWS_DESCRIPTOR) {
                for (el0 in input.mediaConnectFlows) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMediaConnectFlowRequestDocument))
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.sources != null) {
            listField(SOURCES_DESCRIPTOR) {
                for (el0 in input.sources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputSourceRequestDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
