// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.medialive.model.MediaLiveException
import aws.sdk.kotlin.services.medialive.model.MultiplexProgram
import aws.sdk.kotlin.services.medialive.model.UpdateMultiplexProgramResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateMultiplexProgramOperationDeserializer: HttpDeserialize<UpdateMultiplexProgramResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateMultiplexProgramResponse {
        if (!response.status.isSuccess()) {
            throwUpdateMultiplexProgramError(context, response)
        }
        val builder = UpdateMultiplexProgramResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateMultiplexProgramOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateMultiplexProgramError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaLiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaLiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateMultiplexProgramOperationBody(builder: UpdateMultiplexProgramResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MULTIPLEXPROGRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multiplexProgram"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MULTIPLEXPROGRAM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MULTIPLEXPROGRAM_DESCRIPTOR.index -> builder.multiplexProgram = deserializeMultiplexProgramDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
