// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.waiters

import aws.sdk.kotlin.services.medialive.MediaLiveClient
import aws.sdk.kotlin.services.medialive.model.DescribeChannelRequest
import aws.sdk.kotlin.services.medialive.model.DescribeChannelResponse
import aws.sdk.kotlin.services.medialive.model.DescribeInputRequest
import aws.sdk.kotlin.services.medialive.model.DescribeInputResponse
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a channel has been created
 */
public suspend fun MediaLiveClient.waitUntilChannelCreated(request: DescribeChannelRequest): Outcome<DescribeChannelResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 3_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeChannelRequest, DescribeChannelResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "IDLE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "CREATING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val state = it?.state
            state?.toString() == "CREATE_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChannel(request) }
}

/**
 * Wait until a channel has been created
 */
public suspend fun MediaLiveClient.waitUntilChannelCreated(block: DescribeChannelRequest.Builder.() -> Unit): Outcome<DescribeChannelResponse> =
    waitUntilChannelCreated(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Wait until a channel has been deleted
 */
public suspend fun MediaLiveClient.waitUntilChannelDeleted(request: DescribeChannelRequest): Outcome<DescribeChannelResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeChannelRequest, DescribeChannelResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "DELETED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "DELETING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChannel(request) }
}

/**
 * Wait until a channel has been deleted
 */
public suspend fun MediaLiveClient.waitUntilChannelDeleted(block: DescribeChannelRequest.Builder.() -> Unit): Outcome<DescribeChannelResponse> =
    waitUntilChannelDeleted(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Wait until a channel is running
 */
public suspend fun MediaLiveClient.waitUntilChannelRunning(request: DescribeChannelRequest): Outcome<DescribeChannelResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeChannelRequest, DescribeChannelResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "RUNNING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "STARTING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChannel(request) }
}

/**
 * Wait until a channel is running
 */
public suspend fun MediaLiveClient.waitUntilChannelRunning(block: DescribeChannelRequest.Builder.() -> Unit): Outcome<DescribeChannelResponse> =
    waitUntilChannelRunning(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Wait until a channel has is stopped
 */
public suspend fun MediaLiveClient.waitUntilChannelStopped(request: DescribeChannelRequest): Outcome<DescribeChannelResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeChannelRequest, DescribeChannelResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "IDLE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "STOPPING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChannel(request) }
}

/**
 * Wait until a channel has is stopped
 */
public suspend fun MediaLiveClient.waitUntilChannelStopped(block: DescribeChannelRequest.Builder.() -> Unit): Outcome<DescribeChannelResponse> =
    waitUntilChannelStopped(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Wait until an input has been attached
 */
public suspend fun MediaLiveClient.waitUntilInputAttached(request: DescribeInputRequest): Outcome<DescribeInputResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInputRequest, DescribeInputResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "ATTACHED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "DETACHED"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInput(request) }
}

/**
 * Wait until an input has been attached
 */
public suspend fun MediaLiveClient.waitUntilInputAttached(block: DescribeInputRequest.Builder.() -> Unit): Outcome<DescribeInputResponse> =
    waitUntilInputAttached(DescribeInputRequest.Builder().apply(block).build())

/**
 * Wait until an input has been deleted
 */
public suspend fun MediaLiveClient.waitUntilInputDeleted(request: DescribeInputRequest): Outcome<DescribeInputResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInputRequest, DescribeInputResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "DELETED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "DELETING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInput(request) }
}

/**
 * Wait until an input has been deleted
 */
public suspend fun MediaLiveClient.waitUntilInputDeleted(block: DescribeInputRequest.Builder.() -> Unit): Outcome<DescribeInputResponse> =
    waitUntilInputDeleted(DescribeInputRequest.Builder().apply(block).build())

/**
 * Wait until an input has been detached
 */
public suspend fun MediaLiveClient.waitUntilInputDetached(request: DescribeInputRequest): Outcome<DescribeInputResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInputRequest, DescribeInputResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "DETACHED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "CREATING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "ATTACHED"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInput(request) }
}

/**
 * Wait until an input has been detached
 */
public suspend fun MediaLiveClient.waitUntilInputDetached(block: DescribeInputRequest.Builder.() -> Unit): Outcome<DescribeInputResponse> =
    waitUntilInputDetached(DescribeInputRequest.Builder().apply(block).build())

/**
 * Wait until a multiplex has been created
 */
public suspend fun MediaLiveClient.waitUntilMultiplexCreated(request: DescribeMultiplexRequest): Outcome<DescribeMultiplexResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 3_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeMultiplexRequest, DescribeMultiplexResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "IDLE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "CREATING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val state = it?.state
            state?.toString() == "CREATE_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMultiplex(request) }
}

/**
 * Wait until a multiplex has been created
 */
public suspend fun MediaLiveClient.waitUntilMultiplexCreated(block: DescribeMultiplexRequest.Builder.() -> Unit): Outcome<DescribeMultiplexResponse> =
    waitUntilMultiplexCreated(DescribeMultiplexRequest.Builder().apply(block).build())

/**
 * Wait until a multiplex has been deleted
 */
public suspend fun MediaLiveClient.waitUntilMultiplexDeleted(request: DescribeMultiplexRequest): Outcome<DescribeMultiplexResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeMultiplexRequest, DescribeMultiplexResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "DELETED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "DELETING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMultiplex(request) }
}

/**
 * Wait until a multiplex has been deleted
 */
public suspend fun MediaLiveClient.waitUntilMultiplexDeleted(block: DescribeMultiplexRequest.Builder.() -> Unit): Outcome<DescribeMultiplexResponse> =
    waitUntilMultiplexDeleted(DescribeMultiplexRequest.Builder().apply(block).build())

/**
 * Wait until a multiplex is running
 */
public suspend fun MediaLiveClient.waitUntilMultiplexRunning(request: DescribeMultiplexRequest): Outcome<DescribeMultiplexResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeMultiplexRequest, DescribeMultiplexResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "RUNNING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "STARTING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMultiplex(request) }
}

/**
 * Wait until a multiplex is running
 */
public suspend fun MediaLiveClient.waitUntilMultiplexRunning(block: DescribeMultiplexRequest.Builder.() -> Unit): Outcome<DescribeMultiplexResponse> =
    waitUntilMultiplexRunning(DescribeMultiplexRequest.Builder().apply(block).build())

/**
 * Wait until a multiplex has is stopped
 */
public suspend fun MediaLiveClient.waitUntilMultiplexStopped(request: DescribeMultiplexRequest): Outcome<DescribeMultiplexResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeMultiplexRequest, DescribeMultiplexResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val state = it?.state
            state?.toString() == "IDLE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val state = it?.state
            state?.toString() == "STOPPING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMultiplex(request) }
}

/**
 * Wait until a multiplex has is stopped
 */
public suspend fun MediaLiveClient.waitUntilMultiplexStopped(block: DescribeMultiplexRequest.Builder.() -> Unit): Outcome<DescribeMultiplexResponse> =
    waitUntilMultiplexStopped(DescribeMultiplexRequest.Builder().apply(block).build())
