// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediapackage.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediapackage.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Elemental MediaPackage
 */
interface MediaPackageClient : SdkClient {

    override val serviceName: String
        get() = "MediaPackage"
    /**
     * MediaPackageClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MediaPackageClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaPackageClient(config)
        }

        operator fun invoke(config: Config): MediaPackageClient = DefaultMediaPackageClient(config)

        /**
         * Construct a [MediaPackageClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaPackageClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaPackageClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Changes the Channel's properities to configure log subscription
     */
    suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse

    /**
     * Changes the Channel's properities to configure log subscription
     */
    suspend fun configureLogs(block: ConfigureLogsRequest.Builder.() -> Unit) = configureLogs(ConfigureLogsRequest.Builder().apply(block).build())

    /**
     * Creates a new Channel.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a new Channel.
     */
    suspend fun createChannel(block: CreateChannelRequest.Builder.() -> Unit) = createChannel(CreateChannelRequest.Builder().apply(block).build())

    /**
     * Creates a new HarvestJob record.
     */
    suspend fun createHarvestJob(input: CreateHarvestJobRequest): CreateHarvestJobResponse

    /**
     * Creates a new HarvestJob record.
     */
    suspend fun createHarvestJob(block: CreateHarvestJobRequest.Builder.() -> Unit) = createHarvestJob(CreateHarvestJobRequest.Builder().apply(block).build())

    /**
     * Creates a new OriginEndpoint record.
     */
    suspend fun createOriginEndpoint(input: CreateOriginEndpointRequest): CreateOriginEndpointResponse

    /**
     * Creates a new OriginEndpoint record.
     */
    suspend fun createOriginEndpoint(block: CreateOriginEndpointRequest.Builder.() -> Unit) = createOriginEndpoint(CreateOriginEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes an existing Channel.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes an existing Channel.
     */
    suspend fun deleteChannel(block: DeleteChannelRequest.Builder.() -> Unit) = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

    /**
     * Deletes an existing OriginEndpoint.
     */
    suspend fun deleteOriginEndpoint(input: DeleteOriginEndpointRequest): DeleteOriginEndpointResponse

    /**
     * Deletes an existing OriginEndpoint.
     */
    suspend fun deleteOriginEndpoint(block: DeleteOriginEndpointRequest.Builder.() -> Unit) = deleteOriginEndpoint(DeleteOriginEndpointRequest.Builder().apply(block).build())

    /**
     * Gets details about a Channel.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Gets details about a Channel.
     */
    suspend fun describeChannel(block: DescribeChannelRequest.Builder.() -> Unit) = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

    /**
     * Gets details about an existing HarvestJob.
     */
    suspend fun describeHarvestJob(input: DescribeHarvestJobRequest): DescribeHarvestJobResponse

    /**
     * Gets details about an existing HarvestJob.
     */
    suspend fun describeHarvestJob(block: DescribeHarvestJobRequest.Builder.() -> Unit) = describeHarvestJob(DescribeHarvestJobRequest.Builder().apply(block).build())

    /**
     * Gets details about an existing OriginEndpoint.
     */
    suspend fun describeOriginEndpoint(input: DescribeOriginEndpointRequest): DescribeOriginEndpointResponse

    /**
     * Gets details about an existing OriginEndpoint.
     */
    suspend fun describeOriginEndpoint(block: DescribeOriginEndpointRequest.Builder.() -> Unit) = describeOriginEndpoint(DescribeOriginEndpointRequest.Builder().apply(block).build())

    /**
     * Returns a collection of Channels.
     */
    suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Returns a collection of Channels.
     */
    suspend fun listChannels(block: ListChannelsRequest.Builder.() -> Unit) = listChannels(ListChannelsRequest.Builder().apply(block).build())

    /**
     * Returns a collection of HarvestJob records.
     */
    suspend fun listHarvestJobs(input: ListHarvestJobsRequest = ListHarvestJobsRequest {}): ListHarvestJobsResponse

    /**
     * Returns a collection of HarvestJob records.
     */
    suspend fun listHarvestJobs(block: ListHarvestJobsRequest.Builder.() -> Unit) = listHarvestJobs(ListHarvestJobsRequest.Builder().apply(block).build())

    /**
     * Returns a collection of OriginEndpoint records.
     */
    suspend fun listOriginEndpoints(input: ListOriginEndpointsRequest = ListOriginEndpointsRequest {}): ListOriginEndpointsResponse

    /**
     * Returns a collection of OriginEndpoint records.
     */
    suspend fun listOriginEndpoints(block: ListOriginEndpointsRequest.Builder.() -> Unit) = listOriginEndpoints(ListOriginEndpointsRequest.Builder().apply(block).build())

    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun rotateChannelCredentials(input: RotateChannelCredentialsRequest): RotateChannelCredentialsResponse

    /**
     * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun rotateChannelCredentials(block: RotateChannelCredentialsRequest.Builder.() -> Unit) = rotateChannelCredentials(RotateChannelCredentialsRequest.Builder().apply(block).build())

    /**
     * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
     */
    suspend fun rotateIngestEndpointCredentials(input: RotateIngestEndpointCredentialsRequest): RotateIngestEndpointCredentialsResponse

    /**
     * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
     */
    suspend fun rotateIngestEndpointCredentials(block: RotateIngestEndpointCredentialsRequest.Builder.() -> Unit) = rotateIngestEndpointCredentials(RotateIngestEndpointCredentialsRequest.Builder().apply(block).build())

    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an existing Channel.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates an existing Channel.
     */
    suspend fun updateChannel(block: UpdateChannelRequest.Builder.() -> Unit) = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

    /**
     * Updates an existing OriginEndpoint.
     */
    suspend fun updateOriginEndpoint(input: UpdateOriginEndpointRequest): UpdateOriginEndpointResponse

    /**
     * Updates an existing OriginEndpoint.
     */
    suspend fun updateOriginEndpoint(block: UpdateOriginEndpointRequest.Builder.() -> Unit) = updateOriginEndpoint(UpdateOriginEndpointRequest.Builder().apply(block).build())
}
