// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * A Common Media Application Format (CMAF) packaging configuration.
 */
class CmafPackageCreateOrUpdateParameters private constructor(builder: Builder) {
    /**
     * A Common Media Application Format (CMAF) encryption configuration.
     */
    val encryption: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption? = builder.encryption
    /**
     * A list of HLS manifest configurations
     */
    val hlsManifests: List<HlsManifestCreateOrUpdateParameters>? = builder.hlsManifests
    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
     */
    val segmentDurationSeconds: kotlin.Int? = builder.segmentDurationSeconds
    /**
     * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
     */
    val segmentPrefix: kotlin.String? = builder.segmentPrefix
    /**
     * A StreamSelection configuration.
     */
    val streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = builder.streamSelection

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmafPackageCreateOrUpdateParameters(")
        append("encryption=$encryption,")
        append("hlsManifests=$hlsManifests,")
        append("segmentDurationSeconds=$segmentDurationSeconds,")
        append("segmentPrefix=$segmentPrefix,")
        append("streamSelection=$streamSelection)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryption?.hashCode() ?: 0
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (segmentDurationSeconds ?: 0)
        result = 31 * result + (segmentPrefix?.hashCode() ?: 0)
        result = 31 * result + (streamSelection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmafPackageCreateOrUpdateParameters

        if (encryption != other.encryption) return false
        if (hlsManifests != other.hlsManifests) return false
        if (segmentDurationSeconds != other.segmentDurationSeconds) return false
        if (segmentPrefix != other.segmentPrefix) return false
        if (streamSelection != other.streamSelection) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * A Common Media Application Format (CMAF) encryption configuration.
         */
        var encryption: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption? = null
        /**
         * A list of HLS manifest configurations
         */
        var hlsManifests: List<HlsManifestCreateOrUpdateParameters>? = null
        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
         */
        var segmentDurationSeconds: kotlin.Int? = null
        /**
         * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
         */
        var segmentPrefix: kotlin.String? = null
        /**
         * A StreamSelection configuration.
         */
        var streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters) : this() {
            this.encryption = x.encryption
            this.hlsManifests = x.hlsManifests
            this.segmentDurationSeconds = x.segmentDurationSeconds
            this.segmentPrefix = x.segmentPrefix
            this.streamSelection = x.streamSelection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters = CmafPackageCreateOrUpdateParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.CmafEncryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediapackage.model.CmafEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.StreamSelection] inside the given [block]
         */
        fun streamSelection(block: aws.sdk.kotlin.services.mediapackage.model.StreamSelection.Builder.() -> kotlin.Unit) {
            this.streamSelection = aws.sdk.kotlin.services.mediapackage.model.StreamSelection.invoke(block)
        }
    }
}
