// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * An HTTP Live Streaming (HLS) encryption configuration.
 */
class HlsEncryption private constructor(builder: Builder) {
    /**
     * A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
     */
    val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * The encryption method to use.
     */
    val encryptionMethod: aws.sdk.kotlin.services.mediapackage.model.EncryptionMethod? = builder.encryptionMethod
    /**
     * Interval (in seconds) between each encryption key rotation.
     */
    val keyRotationIntervalSeconds: kotlin.Int? = builder.keyRotationIntervalSeconds
    /**
     * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     */
    val repeatExtXKey: kotlin.Boolean? = builder.repeatExtXKey
    /**
     * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
     */
    val spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = builder.spekeKeyProvider

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsEncryption(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("encryptionMethod=$encryptionMethod,")
        append("keyRotationIntervalSeconds=$keyRotationIntervalSeconds,")
        append("repeatExtXKey=$repeatExtXKey,")
        append("spekeKeyProvider=$spekeKeyProvider)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (encryptionMethod?.hashCode() ?: 0)
        result = 31 * result + (keyRotationIntervalSeconds ?: 0)
        result = 31 * result + (repeatExtXKey?.hashCode() ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsEncryption

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (encryptionMethod != other.encryptionMethod) return false
        if (keyRotationIntervalSeconds != other.keyRotationIntervalSeconds) return false
        if (repeatExtXKey != other.repeatExtXKey) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = Builder(this).apply(block).build()

    class Builder {
        /**
         * A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
         */
        var constantInitializationVector: kotlin.String? = null
        /**
         * The encryption method to use.
         */
        var encryptionMethod: aws.sdk.kotlin.services.mediapackage.model.EncryptionMethod? = null
        /**
         * Interval (in seconds) between each encryption key rotation.
         */
        var keyRotationIntervalSeconds: kotlin.Int? = null
        /**
         * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         */
        var repeatExtXKey: kotlin.Boolean? = null
        /**
         * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
         */
        var spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.HlsEncryption) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.encryptionMethod = x.encryptionMethod
            this.keyRotationIntervalSeconds = x.keyRotationIntervalSeconds
            this.repeatExtXKey = x.repeatExtXKey
            this.spekeKeyProvider = x.spekeKeyProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = HlsEncryption(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider] inside the given [block]
         */
        fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.invoke(block)
        }
    }
}
