// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * Configuration parameters for where in an S3 bucket to place the harvested content
 */
class S3Destination private constructor(builder: Builder) {
    /**
     * The name of an S3 bucket within which harvested content will be exported
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
     */
    val manifestKey: kotlin.String? = builder.manifestKey
    /**
     * The IAM role used to write to the specified S3 bucket
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucketName=$bucketName,")
        append("manifestKey=$manifestKey,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (manifestKey?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucketName != other.bucketName) return false
        if (manifestKey != other.manifestKey) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.S3Destination = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an S3 bucket within which harvested content will be exported
         */
        var bucketName: kotlin.String? = null
        /**
         * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
         */
        var manifestKey: kotlin.String? = null
        /**
         * The IAM role used to write to the specified S3 bucket
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.S3Destination) : this() {
            this.bucketName = x.bucketName
            this.manifestKey = x.manifestKey
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.S3Destination = S3Destination(this)
    }
}
