// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediapackage.model.ConfigureLogsResponse
import aws.sdk.kotlin.services.mediapackage.model.EgressAccessLogs
import aws.sdk.kotlin.services.mediapackage.model.HlsIngest
import aws.sdk.kotlin.services.mediapackage.model.IngressAccessLogs
import aws.sdk.kotlin.services.mediapackage.model.MediaPackageException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ConfigureLogsOperationDeserializer: HttpDeserialize<ConfigureLogsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ConfigureLogsResponse {
        if (!response.status.isSuccess()) {
            throwConfigureLogsError(context, response)
        }
        val builder = ConfigureLogsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeConfigureLogsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwConfigureLogsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeConfigureLogsOperationBody(builder: ConfigureLogsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EGRESSACCESSLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("egressAccessLogs"))
    val HLSINGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsIngest"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val INGRESSACCESSLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ingressAccessLogs"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EGRESSACCESSLOGS_DESCRIPTOR)
        field(HLSINGEST_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INGRESSACCESSLOGS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EGRESSACCESSLOGS_DESCRIPTOR.index -> builder.egressAccessLogs = deserializeEgressAccessLogsDocument(deserializer)
                HLSINGEST_DESCRIPTOR.index -> builder.hlsIngest = deserializeHlsIngestDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INGRESSACCESSLOGS_DESCRIPTOR.index -> builder.ingressAccessLogs = deserializeIngressAccessLogsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
