// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * A Common Media Application Format (CMAF) encryption configuration.
 */
class CmafEncryption private constructor(builder: Builder) {
    /**
     * An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
     */
    val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * Time (in seconds) between each encryption key rotation.
     */
    val keyRotationIntervalSeconds: kotlin.Int? = builder.keyRotationIntervalSeconds
    /**
     * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
     */
    val spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = builder.spekeKeyProvider

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.CmafEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmafEncryption(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("keyRotationIntervalSeconds=$keyRotationIntervalSeconds,")
        append("spekeKeyProvider=$spekeKeyProvider)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (keyRotationIntervalSeconds ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmafEncryption

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (keyRotationIntervalSeconds != other.keyRotationIntervalSeconds) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.CmafEncryption = Builder(this).apply(block).build()

    class Builder {
        /**
         * An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
         */
        var constantInitializationVector: kotlin.String? = null
        /**
         * Time (in seconds) between each encryption key rotation.
         */
        var keyRotationIntervalSeconds: kotlin.Int? = null
        /**
         * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
         */
        var spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.keyRotationIntervalSeconds = x.keyRotationIntervalSeconds
            this.spekeKeyProvider = x.spekeKeyProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.CmafEncryption = CmafEncryption(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider] inside the given [block]
         */
        fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.invoke(block)
        }
    }
}
