// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * A HTTP Live Streaming (HLS) manifest configuration.
 */
class HlsManifest private constructor(builder: Builder) {
    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
     */
    val adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = builder.adMarkers
    /**
     * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
     */
    val id: kotlin.String? = builder.id
    /**
     * When enabled, an I-Frame only stream will be included in the output.
     */
    val includeIframeOnlyStream: kotlin.Boolean? = builder.includeIframeOnlyStream
    /**
     * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
     */
    val manifestName: kotlin.String? = builder.manifestName
    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     */
    val playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = builder.playlistType
    /**
     * Time window (in seconds) contained in each parent manifest.
     */
    val playlistWindowSeconds: kotlin.Int? = builder.playlistWindowSeconds
    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     */
    val programDateTimeIntervalSeconds: kotlin.Int? = builder.programDateTimeIntervalSeconds
    /**
     * The URL of the packaged OriginEndpoint for consumption.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.HlsManifest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsManifest(")
        append("adMarkers=$adMarkers,")
        append("id=$id,")
        append("includeIframeOnlyStream=$includeIframeOnlyStream,")
        append("manifestName=$manifestName,")
        append("playlistType=$playlistType,")
        append("playlistWindowSeconds=$playlistWindowSeconds,")
        append("programDateTimeIntervalSeconds=$programDateTimeIntervalSeconds,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (includeIframeOnlyStream?.hashCode() ?: 0)
        result = 31 * result + (manifestName?.hashCode() ?: 0)
        result = 31 * result + (playlistType?.hashCode() ?: 0)
        result = 31 * result + (playlistWindowSeconds ?: 0)
        result = 31 * result + (programDateTimeIntervalSeconds ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsManifest

        if (adMarkers != other.adMarkers) return false
        if (id != other.id) return false
        if (includeIframeOnlyStream != other.includeIframeOnlyStream) return false
        if (manifestName != other.manifestName) return false
        if (playlistType != other.playlistType) return false
        if (playlistWindowSeconds != other.playlistWindowSeconds) return false
        if (programDateTimeIntervalSeconds != other.programDateTimeIntervalSeconds) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.HlsManifest = Builder(this).apply(block).build()

    class Builder {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
         */
        var adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = null
        /**
         * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
         */
        var id: kotlin.String? = null
        /**
         * When enabled, an I-Frame only stream will be included in the output.
         */
        var includeIframeOnlyStream: kotlin.Boolean? = null
        /**
         * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
         */
        var manifestName: kotlin.String? = null
        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         */
        var playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = null
        /**
         * Time window (in seconds) contained in each parent manifest.
         */
        var playlistWindowSeconds: kotlin.Int? = null
        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
         */
        var programDateTimeIntervalSeconds: kotlin.Int? = null
        /**
         * The URL of the packaged OriginEndpoint for consumption.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.HlsManifest) : this() {
            this.adMarkers = x.adMarkers
            this.id = x.id
            this.includeIframeOnlyStream = x.includeIframeOnlyStream
            this.manifestName = x.manifestName
            this.playlistType = x.playlistType
            this.playlistWindowSeconds = x.playlistWindowSeconds
            this.programDateTimeIntervalSeconds = x.programDateTimeIntervalSeconds
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.HlsManifest = HlsManifest(this)
    }
}
