// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediapackage.model.CreateHarvestJobResponse
import aws.sdk.kotlin.services.mediapackage.model.MediaPackageException
import aws.sdk.kotlin.services.mediapackage.model.S3Destination
import aws.sdk.kotlin.services.mediapackage.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHarvestJobOperationDeserializer: HttpDeserialize<CreateHarvestJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateHarvestJobResponse {
        if (!response.status.isSuccess()) {
            throwCreateHarvestJobError(context, response)
        }
        val builder = CreateHarvestJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateHarvestJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateHarvestJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHarvestJobOperationBody(builder: CreateHarvestJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdAt"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endTime"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val ORIGINENDPOINTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("originEndpointId"))
    val S3DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("s3Destination"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CHANNELID_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(ORIGINENDPOINTID_DESCRIPTOR)
        field(S3DESTINATION_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                ORIGINENDPOINTID_DESCRIPTOR.index -> builder.originEndpointId = deserializeString()
                S3DESTINATION_DESCRIPTOR.index -> builder.s3Destination = deserializeS3DestinationDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
