// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.mediapackage.model.*
import aws.sdk.kotlin.services.mediapackage.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "MediaPackage"
public const val ServiceApiVersion: String = "2017-10-12"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultMediaPackageClient(override val config: MediaPackageClient.Config) : MediaPackageClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Changes the Channel's properities to configure log subscription
     */
    override suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse {
        val op = SdkHttpOperation.build<ConfigureLogsRequest, ConfigureLogsResponse> {
            serializer = ConfigureLogsOperationSerializer()
            deserializer = ConfigureLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfigureLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Channel.
     */
    override suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse {
        val op = SdkHttpOperation.build<CreateChannelRequest, CreateChannelResponse> {
            serializer = CreateChannelOperationSerializer()
            deserializer = CreateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new HarvestJob record.
     */
    override suspend fun createHarvestJob(input: CreateHarvestJobRequest): CreateHarvestJobResponse {
        val op = SdkHttpOperation.build<CreateHarvestJobRequest, CreateHarvestJobResponse> {
            serializer = CreateHarvestJobOperationSerializer()
            deserializer = CreateHarvestJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHarvestJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new OriginEndpoint record.
     */
    override suspend fun createOriginEndpoint(input: CreateOriginEndpointRequest): CreateOriginEndpointResponse {
        val op = SdkHttpOperation.build<CreateOriginEndpointRequest, CreateOriginEndpointResponse> {
            serializer = CreateOriginEndpointOperationSerializer()
            deserializer = CreateOriginEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOriginEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Channel.
     */
    override suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse {
        val op = SdkHttpOperation.build<DeleteChannelRequest, DeleteChannelResponse> {
            serializer = DeleteChannelOperationSerializer()
            deserializer = DeleteChannelOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing OriginEndpoint.
     */
    override suspend fun deleteOriginEndpoint(input: DeleteOriginEndpointRequest): DeleteOriginEndpointResponse {
        val op = SdkHttpOperation.build<DeleteOriginEndpointRequest, DeleteOriginEndpointResponse> {
            serializer = DeleteOriginEndpointOperationSerializer()
            deserializer = DeleteOriginEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteOriginEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a Channel.
     */
    override suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse {
        val op = SdkHttpOperation.build<DescribeChannelRequest, DescribeChannelResponse> {
            serializer = DescribeChannelOperationSerializer()
            deserializer = DescribeChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about an existing HarvestJob.
     */
    override suspend fun describeHarvestJob(input: DescribeHarvestJobRequest): DescribeHarvestJobResponse {
        val op = SdkHttpOperation.build<DescribeHarvestJobRequest, DescribeHarvestJobResponse> {
            serializer = DescribeHarvestJobOperationSerializer()
            deserializer = DescribeHarvestJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHarvestJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about an existing OriginEndpoint.
     */
    override suspend fun describeOriginEndpoint(input: DescribeOriginEndpointRequest): DescribeOriginEndpointResponse {
        val op = SdkHttpOperation.build<DescribeOriginEndpointRequest, DescribeOriginEndpointResponse> {
            serializer = DescribeOriginEndpointOperationSerializer()
            deserializer = DescribeOriginEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOriginEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a collection of Channels.
     */
    override suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse {
        val op = SdkHttpOperation.build<ListChannelsRequest, ListChannelsResponse> {
            serializer = ListChannelsOperationSerializer()
            deserializer = ListChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a collection of HarvestJob records.
     */
    override suspend fun listHarvestJobs(input: ListHarvestJobsRequest): ListHarvestJobsResponse {
        val op = SdkHttpOperation.build<ListHarvestJobsRequest, ListHarvestJobsResponse> {
            serializer = ListHarvestJobsOperationSerializer()
            deserializer = ListHarvestJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListHarvestJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a collection of OriginEndpoint records.
     */
    override suspend fun listOriginEndpoints(input: ListOriginEndpointsRequest): ListOriginEndpointsResponse {
        val op = SdkHttpOperation.build<ListOriginEndpointsRequest, ListOriginEndpointsResponse> {
            serializer = ListOriginEndpointsOperationSerializer()
            deserializer = ListOriginEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOriginEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun rotateChannelCredentials(input: RotateChannelCredentialsRequest): RotateChannelCredentialsResponse {
        val op = SdkHttpOperation.build<RotateChannelCredentialsRequest, RotateChannelCredentialsResponse> {
            serializer = RotateChannelCredentialsOperationSerializer()
            deserializer = RotateChannelCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RotateChannelCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
     */
    override suspend fun rotateIngestEndpointCredentials(input: RotateIngestEndpointCredentialsRequest): RotateIngestEndpointCredentialsResponse {
        val op = SdkHttpOperation.build<RotateIngestEndpointCredentialsRequest, RotateIngestEndpointCredentialsResponse> {
            serializer = RotateIngestEndpointCredentialsOperationSerializer()
            deserializer = RotateIngestEndpointCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RotateIngestEndpointCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Channel.
     */
    override suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse {
        val op = SdkHttpOperation.build<UpdateChannelRequest, UpdateChannelResponse> {
            serializer = UpdateChannelOperationSerializer()
            deserializer = UpdateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing OriginEndpoint.
     */
    override suspend fun updateOriginEndpoint(input: UpdateOriginEndpointRequest): UpdateOriginEndpointResponse {
        val op = SdkHttpOperation.build<UpdateOriginEndpointRequest, UpdateOriginEndpointResponse> {
            serializer = UpdateOriginEndpointOperationSerializer()
            deserializer = UpdateOriginEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOriginEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediapackage"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mediapackage")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
