// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediapackage.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediapackage.model.*
import aws.sdk.kotlin.services.mediapackage.model.ConfigureLogsRequest
import aws.sdk.kotlin.services.mediapackage.model.ConfigureLogsResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateHarvestJobRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateHarvestJobResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.DeleteChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.DeleteChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.DeleteOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.DeleteOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeHarvestJobRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeHarvestJobResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.RotateChannelCredentialsRequest
import aws.sdk.kotlin.services.mediapackage.model.RotateChannelCredentialsResponse
import aws.sdk.kotlin.services.mediapackage.model.RotateIngestEndpointCredentialsRequest
import aws.sdk.kotlin.services.mediapackage.model.RotateIngestEndpointCredentialsResponse
import aws.sdk.kotlin.services.mediapackage.model.TagResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.TagResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.UpdateChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.UpdateChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Elemental MediaPackage
 */
public interface MediaPackageClient : SdkClient {

    override val serviceName: String
        get() = "MediaPackage"
    /**
     * MediaPackageClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MediaPackageClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaPackageClient(config)
        }

        public operator fun invoke(config: Config): MediaPackageClient = DefaultMediaPackageClient(config)

        /**
         * Construct a [MediaPackageClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaPackageClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaPackageClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Changes the Channel's properities to configure log subscription
     */
    public suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse

    /**
     * Creates a new Channel.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a new HarvestJob record.
     */
    public suspend fun createHarvestJob(input: CreateHarvestJobRequest): CreateHarvestJobResponse

    /**
     * Creates a new OriginEndpoint record.
     */
    public suspend fun createOriginEndpoint(input: CreateOriginEndpointRequest): CreateOriginEndpointResponse

    /**
     * Deletes an existing Channel.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes an existing OriginEndpoint.
     */
    public suspend fun deleteOriginEndpoint(input: DeleteOriginEndpointRequest): DeleteOriginEndpointResponse

    /**
     * Gets details about a Channel.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Gets details about an existing HarvestJob.
     */
    public suspend fun describeHarvestJob(input: DescribeHarvestJobRequest): DescribeHarvestJobResponse

    /**
     * Gets details about an existing OriginEndpoint.
     */
    public suspend fun describeOriginEndpoint(input: DescribeOriginEndpointRequest): DescribeOriginEndpointResponse

    /**
     * Returns a collection of Channels.
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Returns a collection of HarvestJob records.
     */
    public suspend fun listHarvestJobs(input: ListHarvestJobsRequest = ListHarvestJobsRequest {}): ListHarvestJobsResponse

    /**
     * Returns a collection of OriginEndpoint records.
     */
    public suspend fun listOriginEndpoints(input: ListOriginEndpointsRequest = ListOriginEndpointsRequest {}): ListOriginEndpointsResponse

    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun rotateChannelCredentials(input: RotateChannelCredentialsRequest): RotateChannelCredentialsResponse

    /**
     * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
     */
    public suspend fun rotateIngestEndpointCredentials(input: RotateIngestEndpointCredentialsRequest): RotateIngestEndpointCredentialsResponse

    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Channel.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates an existing OriginEndpoint.
     */
    public suspend fun updateOriginEndpoint(input: UpdateOriginEndpointRequest): UpdateOriginEndpointResponse
}

/**
 * Changes the Channel's properities to configure log subscription
 */
public suspend inline fun MediaPackageClient.configureLogs(crossinline block: ConfigureLogsRequest.Builder.() -> Unit): ConfigureLogsResponse = configureLogs(ConfigureLogsRequest.Builder().apply(block).build())

/**
 * Creates a new Channel.
 */
public suspend inline fun MediaPackageClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Creates a new HarvestJob record.
 */
public suspend inline fun MediaPackageClient.createHarvestJob(crossinline block: CreateHarvestJobRequest.Builder.() -> Unit): CreateHarvestJobResponse = createHarvestJob(CreateHarvestJobRequest.Builder().apply(block).build())

/**
 * Creates a new OriginEndpoint record.
 */
public suspend inline fun MediaPackageClient.createOriginEndpoint(crossinline block: CreateOriginEndpointRequest.Builder.() -> Unit): CreateOriginEndpointResponse = createOriginEndpoint(CreateOriginEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an existing Channel.
 */
public suspend inline fun MediaPackageClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.deleteOriginEndpoint(crossinline block: DeleteOriginEndpointRequest.Builder.() -> Unit): DeleteOriginEndpointResponse = deleteOriginEndpoint(DeleteOriginEndpointRequest.Builder().apply(block).build())

/**
 * Gets details about a Channel.
 */
public suspend inline fun MediaPackageClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Gets details about an existing HarvestJob.
 */
public suspend inline fun MediaPackageClient.describeHarvestJob(crossinline block: DescribeHarvestJobRequest.Builder.() -> Unit): DescribeHarvestJobResponse = describeHarvestJob(DescribeHarvestJobRequest.Builder().apply(block).build())

/**
 * Gets details about an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.describeOriginEndpoint(crossinline block: DescribeOriginEndpointRequest.Builder.() -> Unit): DescribeOriginEndpointResponse = describeOriginEndpoint(DescribeOriginEndpointRequest.Builder().apply(block).build())

/**
 * Returns a collection of Channels.
 */
public suspend inline fun MediaPackageClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Returns a collection of HarvestJob records.
 */
public suspend inline fun MediaPackageClient.listHarvestJobs(crossinline block: ListHarvestJobsRequest.Builder.() -> Unit): ListHarvestJobsResponse = listHarvestJobs(ListHarvestJobsRequest.Builder().apply(block).build())

/**
 * Returns a collection of OriginEndpoint records.
 */
public suspend inline fun MediaPackageClient.listOriginEndpoints(crossinline block: ListOriginEndpointsRequest.Builder.() -> Unit): ListOriginEndpointsResponse = listOriginEndpoints(ListOriginEndpointsRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun MediaPackageClient.rotateChannelCredentials(crossinline block: RotateChannelCredentialsRequest.Builder.() -> Unit): RotateChannelCredentialsResponse = rotateChannelCredentials(RotateChannelCredentialsRequest.Builder().apply(block).build())

/**
 * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
 */
public suspend inline fun MediaPackageClient.rotateIngestEndpointCredentials(crossinline block: RotateIngestEndpointCredentialsRequest.Builder.() -> Unit): RotateIngestEndpointCredentialsResponse = rotateIngestEndpointCredentials(RotateIngestEndpointCredentialsRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Channel.
 */
public suspend inline fun MediaPackageClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.updateOriginEndpoint(crossinline block: UpdateOriginEndpointRequest.Builder.() -> Unit): UpdateOriginEndpointResponse = updateOriginEndpoint(UpdateOriginEndpointRequest.Builder().apply(block).build())
