// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * A HTTP Live Streaming (HLS) manifest configuration.
 */
public class HlsManifestCreateOrUpdateParameters private constructor(builder: Builder) {
    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
     */
    public val adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = builder.adMarkers
    /**
     * A list of SCTE-35 message types that are treated as ad markers in the output. If empty, no ad markers are output. Specify multiple items to create ad markers for all of the included message types.
     */
    public val adTriggers: List<AdTriggersElement>? = builder.adTriggers
    /**
     * This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to determine whether a message signals an ad. Choosing "NONE" means no SCTE-35 messages become ads. Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that contain delivery restrictions will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that do not contain delivery restrictions will be treated as ads. Choosing "BOTH" means all SCTE-35 messages of the types specified in AdTriggers will be treated as ads. Note that Splice Insert messages do not have these flags and are always treated as ads if specified in AdTriggers.
     */
    public val adsOnDeliveryRestrictions: aws.sdk.kotlin.services.mediapackage.model.AdsOnDeliveryRestrictions? = builder.adsOnDeliveryRestrictions
    /**
     * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
     */
    public val id: kotlin.String? = builder.id
    /**
     * When enabled, an I-Frame only stream will be included in the output.
     */
    public val includeIframeOnlyStream: kotlin.Boolean? = builder.includeIframeOnlyStream
    /**
     * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
     */
    public val manifestName: kotlin.String? = builder.manifestName
    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     */
    public val playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = builder.playlistType
    /**
     * Time window (in seconds) contained in each parent manifest.
     */
    public val playlistWindowSeconds: kotlin.Int? = builder.playlistWindowSeconds
    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     */
    public val programDateTimeIntervalSeconds: kotlin.Int? = builder.programDateTimeIntervalSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.HlsManifestCreateOrUpdateParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsManifestCreateOrUpdateParameters(")
        append("adMarkers=$adMarkers,")
        append("adTriggers=$adTriggers,")
        append("adsOnDeliveryRestrictions=$adsOnDeliveryRestrictions,")
        append("id=$id,")
        append("includeIframeOnlyStream=$includeIframeOnlyStream,")
        append("manifestName=$manifestName,")
        append("playlistType=$playlistType,")
        append("playlistWindowSeconds=$playlistWindowSeconds,")
        append("programDateTimeIntervalSeconds=$programDateTimeIntervalSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (adTriggers?.hashCode() ?: 0)
        result = 31 * result + (adsOnDeliveryRestrictions?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (includeIframeOnlyStream?.hashCode() ?: 0)
        result = 31 * result + (manifestName?.hashCode() ?: 0)
        result = 31 * result + (playlistType?.hashCode() ?: 0)
        result = 31 * result + (playlistWindowSeconds ?: 0)
        result = 31 * result + (programDateTimeIntervalSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsManifestCreateOrUpdateParameters

        if (adMarkers != other.adMarkers) return false
        if (adTriggers != other.adTriggers) return false
        if (adsOnDeliveryRestrictions != other.adsOnDeliveryRestrictions) return false
        if (id != other.id) return false
        if (includeIframeOnlyStream != other.includeIframeOnlyStream) return false
        if (manifestName != other.manifestName) return false
        if (playlistType != other.playlistType) return false
        if (playlistWindowSeconds != other.playlistWindowSeconds) return false
        if (programDateTimeIntervalSeconds != other.programDateTimeIntervalSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.HlsManifestCreateOrUpdateParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
         */
        public var adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = null
        /**
         * A list of SCTE-35 message types that are treated as ad markers in the output. If empty, no ad markers are output. Specify multiple items to create ad markers for all of the included message types.
         */
        public var adTriggers: List<AdTriggersElement>? = null
        /**
         * This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to determine whether a message signals an ad. Choosing "NONE" means no SCTE-35 messages become ads. Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that contain delivery restrictions will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that do not contain delivery restrictions will be treated as ads. Choosing "BOTH" means all SCTE-35 messages of the types specified in AdTriggers will be treated as ads. Note that Splice Insert messages do not have these flags and are always treated as ads if specified in AdTriggers.
         */
        public var adsOnDeliveryRestrictions: aws.sdk.kotlin.services.mediapackage.model.AdsOnDeliveryRestrictions? = null
        /**
         * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
         */
        public var id: kotlin.String? = null
        /**
         * When enabled, an I-Frame only stream will be included in the output.
         */
        public var includeIframeOnlyStream: kotlin.Boolean? = null
        /**
         * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
         */
        public var manifestName: kotlin.String? = null
        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         */
        public var playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = null
        /**
         * Time window (in seconds) contained in each parent manifest.
         */
        public var playlistWindowSeconds: kotlin.Int? = null
        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
         */
        public var programDateTimeIntervalSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.HlsManifestCreateOrUpdateParameters) : this() {
            this.adMarkers = x.adMarkers
            this.adTriggers = x.adTriggers
            this.adsOnDeliveryRestrictions = x.adsOnDeliveryRestrictions
            this.id = x.id
            this.includeIframeOnlyStream = x.includeIframeOnlyStream
            this.manifestName = x.manifestName
            this.playlistType = x.playlistType
            this.playlistWindowSeconds = x.playlistWindowSeconds
            this.programDateTimeIntervalSeconds = x.programDateTimeIntervalSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.HlsManifestCreateOrUpdateParameters = HlsManifestCreateOrUpdateParameters(this)
    }
}
