// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.paginators

import aws.sdk.kotlin.services.mediapackage.MediaPackageClient
import aws.sdk.kotlin.services.mediapackage.model.Channel
import aws.sdk.kotlin.services.mediapackage.model.HarvestJob
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsResponse
import aws.sdk.kotlin.services.mediapackage.model.OriginEndpoint
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaPackageClient.listChannelsPaginated(initialRequest: ListChannelsRequest): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaPackageClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelsPaginated]
 * to access the nested member [Channel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Channel]
 */
@JvmName("listChannelsResponseChannel")
public fun Flow<ListChannelsResponse>.channels(): Flow<Channel> =
    transform() { response ->
        response.channels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHarvestJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHarvestJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHarvestJobsResponse]
 */
public fun MediaPackageClient.listHarvestJobsPaginated(initialRequest: ListHarvestJobsRequest): Flow<ListHarvestJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHarvestJobsPaginated.listHarvestJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHarvestJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHarvestJobsResponse]
 */
public fun MediaPackageClient.listHarvestJobsPaginated(block: ListHarvestJobsRequest.Builder.() -> Unit): Flow<ListHarvestJobsResponse> =
    listHarvestJobsPaginated(ListHarvestJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHarvestJobsPaginated]
 * to access the nested member [HarvestJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HarvestJob]
 */
@JvmName("listHarvestJobsResponseHarvestJob")
public fun Flow<ListHarvestJobsResponse>.harvestJobs(): Flow<HarvestJob> =
    transform() { response ->
        response.harvestJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOriginEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOriginEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginEndpointsResponse]
 */
public fun MediaPackageClient.listOriginEndpointsPaginated(initialRequest: ListOriginEndpointsRequest): Flow<ListOriginEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOriginEndpointsPaginated.listOriginEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOriginEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginEndpointsResponse]
 */
public fun MediaPackageClient.listOriginEndpointsPaginated(block: ListOriginEndpointsRequest.Builder.() -> Unit): Flow<ListOriginEndpointsResponse> =
    listOriginEndpointsPaginated(ListOriginEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOriginEndpointsPaginated]
 * to access the nested member [OriginEndpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OriginEndpoint]
 */
@JvmName("listOriginEndpointsResponseOriginEndpoint")
public fun Flow<ListOriginEndpointsResponse>.originEndpoints(): Flow<OriginEndpoint> =
    transform() { response ->
        response.originEndpoints?.forEach {
            emit(it)
        }
    }
