// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediapackage.model.Authorization
import aws.sdk.kotlin.services.mediapackage.model.CmafPackage
import aws.sdk.kotlin.services.mediapackage.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.DashPackage
import aws.sdk.kotlin.services.mediapackage.model.HlsPackage
import aws.sdk.kotlin.services.mediapackage.model.MediaPackageException
import aws.sdk.kotlin.services.mediapackage.model.MssPackage
import aws.sdk.kotlin.services.mediapackage.model.Origination
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOriginEndpointOperationDeserializer: HttpDeserialize<CreateOriginEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOriginEndpointResponse {
        if (!response.status.isSuccess()) {
            throwCreateOriginEndpointError(context, response)
        }
        val builder = CreateOriginEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOriginEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateOriginEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOriginEndpointOperationBody(builder: CreateOriginEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorization"))
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val CMAFPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cmafPackage"))
    val DASHPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dashPackage"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HLSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsPackage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MANIFESTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("manifestName"))
    val MSSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mssPackage"))
    val ORIGINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("origination"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("startoverWindowSeconds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIMEDELAYSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeDelaySeconds"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("url"))
    val WHITELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("whitelist"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AUTHORIZATION_DESCRIPTOR)
        field(CHANNELID_DESCRIPTOR)
        field(CMAFPACKAGE_DESCRIPTOR)
        field(DASHPACKAGE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HLSPACKAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MANIFESTNAME_DESCRIPTOR)
        field(MSSPACKAGE_DESCRIPTOR)
        field(ORIGINATION_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEDELAYSECONDS_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(WHITELIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHORIZATION_DESCRIPTOR.index -> builder.authorization = deserializeAuthorizationDocument(deserializer)
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                CMAFPACKAGE_DESCRIPTOR.index -> builder.cmafPackage = deserializeCmafPackageDocument(deserializer)
                DASHPACKAGE_DESCRIPTOR.index -> builder.dashPackage = deserializeDashPackageDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HLSPACKAGE_DESCRIPTOR.index -> builder.hlsPackage = deserializeHlsPackageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MANIFESTNAME_DESCRIPTOR.index -> builder.manifestName = deserializeString()
                MSSPACKAGE_DESCRIPTOR.index -> builder.mssPackage = deserializeMssPackageDocument(deserializer)
                ORIGINATION_DESCRIPTOR.index -> builder.origination = deserializeString().let { Origination.fromValue(it) }
                STARTOVERWINDOWSECONDS_DESCRIPTOR.index -> builder.startoverWindowSeconds = deserializeInt()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TIMEDELAYSECONDS_DESCRIPTOR.index -> builder.timeDelaySeconds = deserializeInt()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                WHITELIST_DESCRIPTOR.index -> builder.whitelist =
                    deserializer.deserializeList(WHITELIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
