// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.memorydb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.memorydb.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * MemoryDB for Redis is a fully managed, Redis-compatible, in-memory database that delivers ultra-fast performance and Multi-AZ durability for modern applications built using microservices architectures. MemoryDB stores the entire database in-memory, enabling low latency and high throughput data access. It is compatible with Redis, a popular open source data store, enabling you to leverage Redis’ flexible and friendly data structures, APIs, and commands.
 */
interface MemoryDbClient : SdkClient {

    override val serviceName: String
        get() = "MemoryDB"
    /**
     * MemoryDbClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MemoryDbClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMemoryDbClient(config)
        }

        operator fun invoke(config: Config): MemoryDbClient = DefaultMemoryDbClient(config)

        /**
         * Construct a [MemoryDbClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MemoryDbClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMemoryDbClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see [Applying the service updates](https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates).
     */
    suspend fun batchUpdateCluster(input: BatchUpdateClusterRequest): BatchUpdateClusterResponse

    /**
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see [Applying the service updates](https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates).
     */
    suspend fun batchUpdateCluster(block: BatchUpdateClusterRequest.Builder.() -> Unit) = batchUpdateCluster(BatchUpdateClusterRequest.Builder().apply(block).build())

    /**
     * Makes a copy of an existing snapshot.
     */
    suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Makes a copy of an existing snapshot.
     */
    suspend fun copySnapshot(block: CopySnapshotRequest.Builder.() -> Unit) = copySnapshot(CopySnapshotRequest.Builder().apply(block).build())

    /**
     * Creates an Access Control List. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun createAcl(input: CreateAclRequest): CreateAclResponse

    /**
     * Creates an Access Control List. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun createAcl(block: CreateAclRequest.Builder.() -> Unit) = createAcl(CreateAclRequest.Builder().apply(block).build())

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     */
    suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     */
    suspend fun createCluster(block: CreateClusterRequest.Builder.() -> Unit) = createCluster(CreateClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see [Configuring engine parameters using parameter groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html).
     */
    suspend fun createParameterGroup(input: CreateParameterGroupRequest): CreateParameterGroupResponse

    /**
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see [Configuring engine parameters using parameter groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html).
     */
    suspend fun createParameterGroup(block: CreateParameterGroupRequest.Builder.() -> Unit) = createParameterGroup(CreateParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a copy of an entire cluster at a specific moment in time.
     */
    suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a copy of an entire cluster at a specific moment in time.
     */
    suspend fun createSnapshot(block: CreateSnapshotRequest.Builder.() -> Unit) = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see [Subnets and subnet groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html).
     */
    suspend fun createSubnetGroup(input: CreateSubnetGroupRequest): CreateSubnetGroupResponse

    /**
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see [Subnets and subnet groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html).
     */
    suspend fun createSubnetGroup(block: CreateSubnetGroupRequest.Builder.() -> Unit) = createSubnetGroup(CreateSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Creates a MemoryDB user. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a MemoryDB user. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun deleteAcl(input: DeleteAclRequest): DeleteAclResponse

    /**
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    suspend fun deleteAcl(block: DeleteAclRequest.Builder.() -> Unit) = deleteAcl(DeleteAclRequest.Builder().apply(block).build())

    /**
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     */
    suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     */
    suspend fun deleteCluster(block: DeleteClusterRequest.Builder.() -> Unit) = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.
     */
    suspend fun deleteParameterGroup(input: DeleteParameterGroupRequest): DeleteParameterGroupResponse

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.
     */
    suspend fun deleteParameterGroup(block: DeleteParameterGroupRequest.Builder.() -> Unit) = deleteParameterGroup(DeleteParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     */
    suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     */
    suspend fun deleteSnapshot(block: DeleteSnapshotRequest.Builder.() -> Unit) = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

    /**
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     */
    suspend fun deleteSubnetGroup(input: DeleteSubnetGroupRequest): DeleteSubnetGroupResponse

    /**
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     */
    suspend fun deleteSubnetGroup(block: DeleteSubnetGroupRequest.Builder.() -> Unit) = deleteSubnetGroup(DeleteSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Returns a list of ACLs
     */
    suspend fun describeAcLs(input: DescribeAcLsRequest = DescribeAcLsRequest {}): DescribeAcLsResponse

    /**
     * Returns a list of ACLs
     */
    suspend fun describeAcLs(block: DescribeAcLsRequest.Builder.() -> Unit) = describeAcLs(DescribeAcLsRequest.Builder().apply(block).build())

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.
     */
    suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest {}): DescribeClustersResponse

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.
     */
    suspend fun describeClusters(block: DescribeClustersRequest.Builder.() -> Unit) = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available Redis engine versions.
     */
    suspend fun describeEngineVersions(input: DescribeEngineVersionsRequest = DescribeEngineVersionsRequest {}): DescribeEngineVersionsResponse

    /**
     * Returns a list of the available Redis engine versions.
     */
    suspend fun describeEngineVersions(block: DescribeEngineVersionsRequest.Builder.() -> Unit) = describeEngineVersions(DescribeEngineVersionsRequest.Builder().apply(block).build())

    /**
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.
     */
    suspend fun describeParameterGroups(input: DescribeParameterGroupsRequest = DescribeParameterGroupsRequest {}): DescribeParameterGroupsResponse

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.
     */
    suspend fun describeParameterGroups(block: DescribeParameterGroupsRequest.Builder.() -> Unit) = describeParameterGroups(DescribeParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    suspend fun describeParameters(input: DescribeParametersRequest): DescribeParametersResponse

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    suspend fun describeParameters(block: DescribeParametersRequest.Builder.() -> Unit) = describeParameters(DescribeParametersRequest.Builder().apply(block).build())

    /**
     * Returns details of the service updates
     */
    suspend fun describeServiceUpdates(input: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest {}): DescribeServiceUpdatesResponse

    /**
     * Returns details of the service updates
     */
    suspend fun describeServiceUpdates(block: DescribeServiceUpdatesRequest.Builder.() -> Unit) = describeServiceUpdates(DescribeServiceUpdatesRequest.Builder().apply(block).build())

    /**
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     */
    suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest {}): DescribeSnapshotsResponse

    /**
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     */
    suspend fun describeSnapshots(block: DescribeSnapshotsRequest.Builder.() -> Unit) = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.
     */
    suspend fun describeSubnetGroups(input: DescribeSubnetGroupsRequest = DescribeSubnetGroupsRequest {}): DescribeSubnetGroupsResponse

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.
     */
    suspend fun describeSubnetGroups(block: DescribeSubnetGroupsRequest.Builder.() -> Unit) = describeSubnetGroups(DescribeSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of users.
     */
    suspend fun describeUsers(input: DescribeUsersRequest = DescribeUsersRequest {}): DescribeUsersResponse

    /**
     * Returns a list of users.
     */
    suspend fun describeUsers(block: DescribeUsersRequest.Builder.() -> Unit) = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

    /**
     * Used to failover a shard
     */
    suspend fun failoverShard(input: FailoverShardRequest): FailoverShardResponse

    /**
     * Used to failover a shard
     */
    suspend fun failoverShard(block: FailoverShardRequest.Builder.() -> Unit) = failoverShard(FailoverShardRequest.Builder().apply(block).build())

    /**
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.
     */
    suspend fun listAllowedNodeTypeUpdates(input: ListAllowedNodeTypeUpdatesRequest): ListAllowedNodeTypeUpdatesResponse

    /**
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.
     */
    suspend fun listAllowedNodeTypeUpdates(block: ListAllowedNodeTypeUpdatesRequest.Builder.() -> Unit) = listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest.Builder().apply(block).build())

    /**
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see [Tagging your MemoryDB resources](https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html)
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see [Tagging your MemoryDB resources](https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html)
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.
     */
    suspend fun resetParameterGroup(input: ResetParameterGroupRequest): ResetParameterGroupResponse

    /**
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.
     */
    suspend fun resetParameterGroup(block: ResetParameterGroupRequest.Builder.() -> Unit) = resetParameterGroup(ResetParameterGroupRequest.Builder().apply(block).build())

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html).
     *
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html).
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html).
     *
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html).
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Use this operation to remove tags on a resource
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Use this operation to remove tags on a resource
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Changes the list of users that belong to the Access Control List.
     */
    suspend fun updateAcl(input: UpdateAclRequest): UpdateAclResponse

    /**
     * Changes the list of users that belong to the Access Control List.
     */
    suspend fun updateAcl(block: UpdateAclRequest.Builder.() -> Unit) = updateAcl(UpdateAclRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.
     */
    suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.
     */
    suspend fun updateCluster(block: UpdateClusterRequest.Builder.() -> Unit) = updateCluster(UpdateClusterRequest.Builder().apply(block).build())

    /**
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun updateParameterGroup(input: UpdateParameterGroupRequest): UpdateParameterGroupResponse

    /**
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun updateParameterGroup(block: UpdateParameterGroupRequest.Builder.() -> Unit) = updateParameterGroup(UpdateParameterGroupRequest.Builder().apply(block).build())

    /**
     * Updates a subnet group. For more information, see [Updating a subnet group](https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html)
     */
    suspend fun updateSubnetGroup(input: UpdateSubnetGroupRequest): UpdateSubnetGroupResponse

    /**
     * Updates a subnet group. For more information, see [Updating a subnet group](https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html)
     */
    suspend fun updateSubnetGroup(block: UpdateSubnetGroupRequest.Builder.() -> Unit) = updateSubnetGroup(UpdateSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Changes user password(s) and/or access string.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Changes user password(s) and/or access string.
     */
    suspend fun updateUser(block: UpdateUserRequest.Builder.() -> Unit) = updateUser(UpdateUserRequest.Builder().apply(block).build())
}
