// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



/**
 * An Access Control List. You can authenticate users with Access Contol Lists. ACLs enable you to control cluster access by grouping users. These Access control lists are designed as a way to organize access to clusters.
 */
class Acl private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the ACL
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A list of clusters associated with the ACL.
     */
    val clusters: List<String>? = builder.clusters
    /**
     * The minimum engine version supported for the ACL
     */
    val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the Access Control List
     */
    val name: kotlin.String? = builder.name
    /**
     * A list of updates being applied to the ACL.
     */
    val pendingChanges: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges? = builder.pendingChanges
    /**
     * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
     */
    val status: kotlin.String? = builder.status
    /**
     * The list of user names that belong to the ACL.
     */
    val userNames: List<String>? = builder.userNames

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Acl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Acl(")
        append("arn=$arn,")
        append("clusters=$clusters,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("name=$name,")
        append("pendingChanges=$pendingChanges,")
        append("status=$status,")
        append("userNames=$userNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clusters?.hashCode() ?: 0)
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pendingChanges?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Acl

        if (arn != other.arn) return false
        if (clusters != other.clusters) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (name != other.name) return false
        if (pendingChanges != other.pendingChanges) return false
        if (status != other.status) return false
        if (userNames != other.userNames) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Acl = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the ACL
         */
        var arn: kotlin.String? = null
        /**
         * A list of clusters associated with the ACL.
         */
        var clusters: List<String>? = null
        /**
         * The minimum engine version supported for the ACL
         */
        var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the Access Control List
         */
        var name: kotlin.String? = null
        /**
         * A list of updates being applied to the ACL.
         */
        var pendingChanges: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges? = null
        /**
         * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
         */
        var status: kotlin.String? = null
        /**
         * The list of user names that belong to the ACL.
         */
        var userNames: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Acl) : this() {
            this.arn = x.arn
            this.clusters = x.clusters
            this.minimumEngineVersion = x.minimumEngineVersion
            this.name = x.name
            this.pendingChanges = x.pendingChanges
            this.status = x.status
            this.userNames = x.userNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Acl = Acl(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.AclPendingChanges] inside the given [block]
         */
        fun pendingChanges(block: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges.Builder.() -> kotlin.Unit) {
            this.pendingChanges = aws.sdk.kotlin.services.memorydb.model.AclPendingChanges.invoke(block)
        }
    }
}
