// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The name of the Access Control List to associate with the cluster.
     */
    val aclName: kotlin.String? = builder.aclName
    /**
     * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The name of the cluster. This value must be unique as it also serves as the cluster identifier.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * An optional description of the cluster.
     */
    val description: kotlin.String? = builder.description
    /**
     * The version number of the Redis engine to be used for the cluster.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ID of the KMS key used to encrypt the cluster.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     */
    val maintenanceWindow: kotlin.String? = builder.maintenanceWindow
    /**
     * The compute and memory capacity of the nodes in the cluster.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
     */
    val numReplicasPerShard: kotlin.Int? = builder.numReplicasPerShard
    /**
     * The number of shards the cluster will contain. The default value is 1.
     */
    val numShards: kotlin.Int? = builder.numShards
    /**
     * The name of the parameter group associated with the cluster.
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * The port number on which each of the nodes accepts connections.
     */
    val port: kotlin.Int? = builder.port
    /**
     * A list of security group names to associate with this cluster.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
     */
    val snapshotArns: List<String>? = builder.snapshotArns
    /**
     * The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
     */
    val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     */
    val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
     *
     *  Example: 05:00-09:00
     *
     *  If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
     */
    val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The name of the subnet group to be used for the cluster.
     */
    val subnetGroupName: kotlin.String? = builder.subnetGroupName
    /**
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A flag to enable in-transit encryption on the cluster.
     */
    val tlsEnabled: kotlin.Boolean? = builder.tlsEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("aclName=$aclName,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceWindow=$maintenanceWindow,")
        append("nodeType=$nodeType,")
        append("numReplicasPerShard=$numReplicasPerShard,")
        append("numShards=$numShards,")
        append("parameterGroupName=$parameterGroupName,")
        append("port=$port,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotArns=$snapshotArns,")
        append("snapshotName=$snapshotName,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetGroupName=$subnetGroupName,")
        append("tags=$tags,")
        append("tlsEnabled=$tlsEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aclName?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numReplicasPerShard ?: 0)
        result = 31 * result + (numShards ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotArns?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (aclName != other.aclName) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceWindow != other.maintenanceWindow) return false
        if (nodeType != other.nodeType) return false
        if (numReplicasPerShard != other.numReplicasPerShard) return false
        if (numShards != other.numShards) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (port != other.port) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotArns != other.snapshotArns) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (tags != other.tags) return false
        if (tlsEnabled != other.tlsEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.CreateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Access Control List to associate with the cluster.
         */
        var aclName: kotlin.String? = null
        /**
         * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The name of the cluster. This value must be unique as it also serves as the cluster identifier.
         */
        var clusterName: kotlin.String? = null
        /**
         * An optional description of the cluster.
         */
        var description: kotlin.String? = null
        /**
         * The version number of the Redis engine to be used for the cluster.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The ID of the KMS key used to encrypt the cluster.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         */
        var maintenanceWindow: kotlin.String? = null
        /**
         * The compute and memory capacity of the nodes in the cluster.
         */
        var nodeType: kotlin.String? = null
        /**
         * The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
         */
        var numReplicasPerShard: kotlin.Int? = null
        /**
         * The number of shards the cluster will contain. The default value is 1.
         */
        var numShards: kotlin.Int? = null
        /**
         * The name of the parameter group associated with the cluster.
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * The port number on which each of the nodes accepts connections.
         */
        var port: kotlin.Int? = null
        /**
         * A list of security group names to associate with this cluster.
         */
        var securityGroupIds: List<String>? = null
        /**
         * A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
         */
        var snapshotArns: List<String>? = null
        /**
         * The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
         */
        var snapshotName: kotlin.String? = null
        /**
         * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         */
        var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
         *
         *  Example: 05:00-09:00
         *
         *  If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
         */
        var snapshotWindow: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * The name of the subnet group to be used for the cluster.
         */
        var subnetGroupName: kotlin.String? = null
        /**
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.
         */
        var tags: List<Tag>? = null
        /**
         * A flag to enable in-transit encryption on the cluster.
         */
        var tlsEnabled: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.CreateClusterRequest) : this() {
            this.aclName = x.aclName
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.clusterName = x.clusterName
            this.description = x.description
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceWindow = x.maintenanceWindow
            this.nodeType = x.nodeType
            this.numReplicasPerShard = x.numReplicasPerShard
            this.numShards = x.numShards
            this.parameterGroupName = x.parameterGroupName
            this.port = x.port
            this.securityGroupIds = x.securityGroupIds
            this.snapshotArns = x.snapshotArns
            this.snapshotName = x.snapshotName
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snsTopicArn = x.snsTopicArn
            this.subnetGroupName = x.subnetGroupName
            this.tags = x.tags
            this.tlsEnabled = x.tlsEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.CreateClusterRequest = CreateClusterRequest(this)
    }
}
