// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeEventsRequest private constructor(builder: Builder) {
    /**
     * The number of minutes worth of events to retrieve.
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the event source for which events are returned. If not specified, all sources are included in the response.
     */
    val sourceName: kotlin.String? = builder.sourceName
    /**
     * The event source to retrieve events for. If no value is specified, all events are returned.
     */
    val sourceType: aws.sdk.kotlin.services.memorydb.model.SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sourceName=$sourceName,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sourceName != other.sourceName) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of minutes worth of events to retrieve.
         */
        var duration: kotlin.Int? = null
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         */
        var maxResults: kotlin.Int? = null
        /**
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
         */
        var nextToken: kotlin.String? = null
        /**
         * The identifier of the event source for which events are returned. If not specified, all sources are included in the response.
         */
        var sourceName: kotlin.String? = null
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         */
        var sourceType: aws.sdk.kotlin.services.memorydb.model.SourceType? = null
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sourceName = x.sourceName
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest = DescribeEventsRequest(this)
    }
}
