// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an individual node within a cluster. Each node runs its own instance of the cluster's protocol-compliant caching software.
 */
class Node private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the node resides
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The date and time when the node was created.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The hostname for connecting to this node.
     */
    val endpoint: aws.sdk.kotlin.services.memorydb.model.Endpoint? = builder.endpoint
    /**
     * The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of the service update on the node
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Node = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Node(")
        append("availabilityZone=$availabilityZone,")
        append("createTime=$createTime,")
        append("endpoint=$endpoint,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Node

        if (availabilityZone != other.availabilityZone) return false
        if (createTime != other.createTime) return false
        if (endpoint != other.endpoint) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Node = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone in which the node resides
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The date and time when the node was created.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The hostname for connecting to this node.
         */
        var endpoint: aws.sdk.kotlin.services.memorydb.model.Endpoint? = null
        /**
         * The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon account.
         */
        var name: kotlin.String? = null
        /**
         * The status of the service update on the node
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Node) : this() {
            this.availabilityZone = x.availabilityZone
            this.createTime = x.createTime
            this.endpoint = x.endpoint
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Node = Node(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: aws.sdk.kotlin.services.memorydb.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.memorydb.model.Endpoint.invoke(block)
        }
    }
}
