// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An update that you can apply to your MemoryDB clusters.
 */
class ServiceUpdate private constructor(builder: Builder) {
    /**
     * The date at which the service update will be automatically applied
     */
    val autoUpdateStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.autoUpdateStartDate
    /**
     * The name of the cluster to which the service update applies
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * Provides details of the service update
     */
    val description: kotlin.String? = builder.description
    /**
     * A list of nodes updated by the service update
     */
    val nodesUpdated: kotlin.String? = builder.nodesUpdated
    /**
     * The date when the service update is initially available
     */
    val releaseDate: aws.smithy.kotlin.runtime.time.Instant? = builder.releaseDate
    /**
     * The unique ID of the service update
     */
    val serviceUpdateName: kotlin.String? = builder.serviceUpdateName
    /**
     * The status of the service update
     */
    val status: aws.sdk.kotlin.services.memorydb.model.ServiceUpdateStatus? = builder.status
    /**
     * Reflects the nature of the service update
     */
    val type: aws.sdk.kotlin.services.memorydb.model.ServiceUpdateType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.ServiceUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceUpdate(")
        append("autoUpdateStartDate=$autoUpdateStartDate,")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("nodesUpdated=$nodesUpdated,")
        append("releaseDate=$releaseDate,")
        append("serviceUpdateName=$serviceUpdateName,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpdateStartDate?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (nodesUpdated?.hashCode() ?: 0)
        result = 31 * result + (releaseDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceUpdate

        if (autoUpdateStartDate != other.autoUpdateStartDate) return false
        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (nodesUpdated != other.nodesUpdated) return false
        if (releaseDate != other.releaseDate) return false
        if (serviceUpdateName != other.serviceUpdateName) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.ServiceUpdate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date at which the service update will be automatically applied
         */
        var autoUpdateStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the cluster to which the service update applies
         */
        var clusterName: kotlin.String? = null
        /**
         * Provides details of the service update
         */
        var description: kotlin.String? = null
        /**
         * A list of nodes updated by the service update
         */
        var nodesUpdated: kotlin.String? = null
        /**
         * The date when the service update is initially available
         */
        var releaseDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the service update
         */
        var serviceUpdateName: kotlin.String? = null
        /**
         * The status of the service update
         */
        var status: aws.sdk.kotlin.services.memorydb.model.ServiceUpdateStatus? = null
        /**
         * Reflects the nature of the service update
         */
        var type: aws.sdk.kotlin.services.memorydb.model.ServiceUpdateType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.ServiceUpdate) : this() {
            this.autoUpdateStartDate = x.autoUpdateStartDate
            this.clusterName = x.clusterName
            this.description = x.description
            this.nodesUpdated = x.nodesUpdated
            this.releaseDate = x.releaseDate
            this.serviceUpdateName = x.serviceUpdateName
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.ServiceUpdate = ServiceUpdate(this)
    }
}
