// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



/**
 * Represents a copy of an entire cluster as of the time when the snapshot was taken.
 */
class Snapshot private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the snapshot.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The configuration of the cluster from which the snapshot was taken
     */
    val clusterConfiguration: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration? = builder.clusterConfiguration
    /**
     * The ID of the KMS key used to encrypt the snapshot.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the snapshot
     */
    val name: kotlin.String? = builder.name
    /**
     * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
     */
    val source: kotlin.String? = builder.source
    /**
     * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("arn=$arn,")
        append("clusterConfiguration=$clusterConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("source=$source,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (arn != other.arn) return false
        if (clusterConfiguration != other.clusterConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (source != other.source) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Snapshot = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN (Amazon Resource Name) of the snapshot.
         */
        var arn: kotlin.String? = null
        /**
         * The configuration of the cluster from which the snapshot was taken
         */
        var clusterConfiguration: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration? = null
        /**
         * The ID of the KMS key used to encrypt the snapshot.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of the snapshot
         */
        var name: kotlin.String? = null
        /**
         * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
         */
        var source: kotlin.String? = null
        /**
         * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Snapshot) : this() {
            this.arn = x.arn
            this.clusterConfiguration = x.clusterConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.source = x.source
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Snapshot = Snapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration] inside the given [block]
         */
        fun clusterConfiguration(block: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.clusterConfiguration = aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration.invoke(block)
        }
    }
}
