// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



class UpdateClusterRequest private constructor(builder: Builder) {
    /**
     * The Access Control List that is associated with the cluster
     */
    val aclName: kotlin.String? = builder.aclName
    /**
     * The name of the cluster to update
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The description of the cluster to update
     */
    val description: kotlin.String? = builder.description
    /**
     * The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The maintenance window to update
     */
    val maintenanceWindow: kotlin.String? = builder.maintenanceWindow
    /**
     * A valid node type that you want to scale this cluster up or down to.
     */
    val nodeType: kotlin.String? = builder.nodeType
    /**
     * The name of the parameter group to update
     */
    val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * The number of replicas that will reside in each shard
     */
    val replicaConfiguration: aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest? = builder.replicaConfiguration
    /**
     * The SecurityGroupIds to update
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The number of shards in the cluster
     */
    val shardConfiguration: aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest? = builder.shardConfiguration
    /**
     * The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     */
    val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
     */
    val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The SNS topic ARN to update
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
     */
    val snsTopicStatus: kotlin.String? = builder.snsTopicStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterRequest(")
        append("aclName=$aclName,")
        append("clusterName=$clusterName,")
        append("description=$description,")
        append("engineVersion=$engineVersion,")
        append("maintenanceWindow=$maintenanceWindow,")
        append("nodeType=$nodeType,")
        append("parameterGroupName=$parameterGroupName,")
        append("replicaConfiguration=$replicaConfiguration,")
        append("securityGroupIds=$securityGroupIds,")
        append("shardConfiguration=$shardConfiguration,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicStatus=$snsTopicStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aclName?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (replicaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (shardConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterRequest

        if (aclName != other.aclName) return false
        if (clusterName != other.clusterName) return false
        if (description != other.description) return false
        if (engineVersion != other.engineVersion) return false
        if (maintenanceWindow != other.maintenanceWindow) return false
        if (nodeType != other.nodeType) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (replicaConfiguration != other.replicaConfiguration) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (shardConfiguration != other.shardConfiguration) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicStatus != other.snsTopicStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Access Control List that is associated with the cluster
         */
        var aclName: kotlin.String? = null
        /**
         * The name of the cluster to update
         */
        var clusterName: kotlin.String? = null
        /**
         * The description of the cluster to update
         */
        var description: kotlin.String? = null
        /**
         * The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The maintenance window to update
         */
        var maintenanceWindow: kotlin.String? = null
        /**
         * A valid node type that you want to scale this cluster up or down to.
         */
        var nodeType: kotlin.String? = null
        /**
         * The name of the parameter group to update
         */
        var parameterGroupName: kotlin.String? = null
        /**
         * The number of replicas that will reside in each shard
         */
        var replicaConfiguration: aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest? = null
        /**
         * The SecurityGroupIds to update
         */
        var securityGroupIds: List<String>? = null
        /**
         * The number of shards in the cluster
         */
        var shardConfiguration: aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest? = null
        /**
         * The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         */
        var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
         */
        var snapshotWindow: kotlin.String? = null
        /**
         * The SNS topic ARN to update
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
         */
        var snsTopicStatus: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest) : this() {
            this.aclName = x.aclName
            this.clusterName = x.clusterName
            this.description = x.description
            this.engineVersion = x.engineVersion
            this.maintenanceWindow = x.maintenanceWindow
            this.nodeType = x.nodeType
            this.parameterGroupName = x.parameterGroupName
            this.replicaConfiguration = x.replicaConfiguration
            this.securityGroupIds = x.securityGroupIds
            this.shardConfiguration = x.shardConfiguration
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicStatus = x.snsTopicStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest = UpdateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest] inside the given [block]
         */
        fun replicaConfiguration(block: aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest.Builder.() -> kotlin.Unit) {
            this.replicaConfiguration = aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest] inside the given [block]
         */
        fun shardConfiguration(block: aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest.Builder.() -> kotlin.Unit) {
            this.shardConfiguration = aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest.invoke(block)
        }
    }
}
