// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



/**
 * You create users and assign them specific permissions by using an access string. You assign the users to Access Control Lists aligned with a specific role (administrators, human resources) that are then deployed to one or more MemoryDB clusters.
 */
class User private constructor(builder: Builder) {
    /**
     * Access permissions string used for this user.
     */
    val accessString: kotlin.String? = builder.accessString
    /**
     * The names of the Access Control Lists to which the user belongs
     */
    val aclNames: List<String>? = builder.aclNames
    /**
     * The Amazon Resource Name (ARN) of the user.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Denotes whether the user requires a password to authenticate.
     */
    val authentication: aws.sdk.kotlin.services.memorydb.model.Authentication? = builder.authentication
    /**
     * The minimum engine version supported for the user
     */
    val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the user
     */
    val name: kotlin.String? = builder.name
    /**
     * Indicates the user status. Can be "active", "modifying" or "deleting".
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("accessString=$accessString,")
        append("aclNames=$aclNames,")
        append("arn=$arn,")
        append("authentication=$authentication,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessString?.hashCode() ?: 0
        result = 31 * result + (aclNames?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (authentication?.hashCode() ?: 0)
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (accessString != other.accessString) return false
        if (aclNames != other.aclNames) return false
        if (arn != other.arn) return false
        if (authentication != other.authentication) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.User = Builder(this).apply(block).build()

    class Builder {
        /**
         * Access permissions string used for this user.
         */
        var accessString: kotlin.String? = null
        /**
         * The names of the Access Control Lists to which the user belongs
         */
        var aclNames: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the user.
         */
        var arn: kotlin.String? = null
        /**
         * Denotes whether the user requires a password to authenticate.
         */
        var authentication: aws.sdk.kotlin.services.memorydb.model.Authentication? = null
        /**
         * The minimum engine version supported for the user
         */
        var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the user
         */
        var name: kotlin.String? = null
        /**
         * Indicates the user status. Can be "active", "modifying" or "deleting".
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.User) : this() {
            this.accessString = x.accessString
            this.aclNames = x.aclNames
            this.arn = x.arn
            this.authentication = x.authentication
            this.minimumEngineVersion = x.minimumEngineVersion
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.User = User(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.Authentication] inside the given [block]
         */
        fun authentication(block: aws.sdk.kotlin.services.memorydb.model.Authentication.Builder.() -> kotlin.Unit) {
            this.authentication = aws.sdk.kotlin.services.memorydb.model.Authentication.invoke(block)
        }
    }
}
