// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.memorydb.model.BatchUpdateClusterResponse
import aws.sdk.kotlin.services.memorydb.model.Cluster
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.UnprocessedCluster
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchUpdateClusterOperationDeserializer: HttpDeserialize<BatchUpdateClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchUpdateClusterResponse {
        if (!response.status.isSuccess()) {
            throwBatchUpdateClusterError(context, response)
        }
        val builder = BatchUpdateClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchUpdateClusterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchUpdateClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUpdateNotFoundFault" -> ServiceUpdateNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchUpdateClusterOperationBody(builder: BatchUpdateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROCESSEDCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedClusters"))
    val UNPROCESSEDCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedClusters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROCESSEDCLUSTERS_DESCRIPTOR)
        field(UNPROCESSEDCLUSTERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDCLUSTERS_DESCRIPTOR.index -> builder.processedClusters =
                    deserializer.deserializeList(PROCESSEDCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Cluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDCLUSTERS_DESCRIPTOR.index -> builder.unprocessedClusters =
                    deserializer.deserializeList(UNPROCESSEDCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedCluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
