// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.memorydb.model.DeleteUserResponse
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.User
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteUserOperationDeserializer: HttpDeserialize<DeleteUserResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteUserResponse {
        if (!response.status.isSuccess()) {
            throwDeleteUserError(context, response)
        }
        val builder = DeleteUserResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteUserOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteUserError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUserStateFault" -> InvalidUserStateFaultDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundFault" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteUserOperationBody(builder: DeleteUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val USER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("User"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(USER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                USER_DESCRIPTOR.index -> builder.user = deserializeUserDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
