// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.SubnetGroup
import aws.sdk.kotlin.services.memorydb.model.UpdateSubnetGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSubnetGroupOperationDeserializer: HttpDeserialize<UpdateSubnetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSubnetGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSubnetGroupError(context, response)
        }
        val builder = UpdateSubnetGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSubnetGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSubnetGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetGroupNotFoundFault" -> SubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetInUse" -> SubnetInUseDeserializer().deserialize(context, wrappedResponse)
        "SubnetNotAllowedFault" -> SubnetNotAllowedFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetQuotaExceededFault" -> SubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSubnetGroupOperationBody(builder: UpdateSubnetGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUBNETGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SubnetGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBNETGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBNETGROUP_DESCRIPTOR.index -> builder.subnetGroup = deserializeSubnetGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
