// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.memorydb.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.memorydb.endpoints.EndpointProvider
import aws.sdk.kotlin.services.memorydb.model.*
import aws.sdk.kotlin.services.memorydb.model.BatchUpdateClusterRequest
import aws.sdk.kotlin.services.memorydb.model.BatchUpdateClusterResponse
import aws.sdk.kotlin.services.memorydb.model.CopySnapshotRequest
import aws.sdk.kotlin.services.memorydb.model.CopySnapshotResponse
import aws.sdk.kotlin.services.memorydb.model.CreateAclRequest
import aws.sdk.kotlin.services.memorydb.model.CreateAclResponse
import aws.sdk.kotlin.services.memorydb.model.CreateClusterRequest
import aws.sdk.kotlin.services.memorydb.model.CreateClusterResponse
import aws.sdk.kotlin.services.memorydb.model.CreateParameterGroupRequest
import aws.sdk.kotlin.services.memorydb.model.CreateParameterGroupResponse
import aws.sdk.kotlin.services.memorydb.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.memorydb.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.memorydb.model.CreateSubnetGroupRequest
import aws.sdk.kotlin.services.memorydb.model.CreateSubnetGroupResponse
import aws.sdk.kotlin.services.memorydb.model.CreateUserRequest
import aws.sdk.kotlin.services.memorydb.model.CreateUserResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteAclRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteAclResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteClusterRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteClusterResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteParameterGroupRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteParameterGroupResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteSubnetGroupRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteSubnetGroupResponse
import aws.sdk.kotlin.services.memorydb.model.DeleteUserRequest
import aws.sdk.kotlin.services.memorydb.model.DeleteUserResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeAcLsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeAcLsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeClustersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeClustersResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeEngineVersionsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeEngineVersionsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeEventsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeParameterGroupsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeParameterGroupsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeParametersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeParametersResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeServiceUpdatesRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeServiceUpdatesResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeSubnetGroupsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeSubnetGroupsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeUsersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeUsersResponse
import aws.sdk.kotlin.services.memorydb.model.FailoverShardRequest
import aws.sdk.kotlin.services.memorydb.model.FailoverShardResponse
import aws.sdk.kotlin.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest
import aws.sdk.kotlin.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
import aws.sdk.kotlin.services.memorydb.model.ListTagsRequest
import aws.sdk.kotlin.services.memorydb.model.ListTagsResponse
import aws.sdk.kotlin.services.memorydb.model.ResetParameterGroupRequest
import aws.sdk.kotlin.services.memorydb.model.ResetParameterGroupResponse
import aws.sdk.kotlin.services.memorydb.model.TagResourceRequest
import aws.sdk.kotlin.services.memorydb.model.TagResourceResponse
import aws.sdk.kotlin.services.memorydb.model.UntagResourceRequest
import aws.sdk.kotlin.services.memorydb.model.UntagResourceResponse
import aws.sdk.kotlin.services.memorydb.model.UpdateAclRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateAclResponse
import aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateClusterResponse
import aws.sdk.kotlin.services.memorydb.model.UpdateParameterGroupRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateParameterGroupResponse
import aws.sdk.kotlin.services.memorydb.model.UpdateSubnetGroupRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateSubnetGroupResponse
import aws.sdk.kotlin.services.memorydb.model.UpdateUserRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * MemoryDB for Redis is a fully managed, Redis-compatible, in-memory database that delivers ultra-fast performance and Multi-AZ durability for modern applications built using microservices architectures. MemoryDB stores the entire database in-memory, enabling low latency and high throughput data access. It is compatible with Redis, a popular open source data store, enabling you to leverage Redis’ flexible and friendly data structures, APIs, and commands.
 */
public interface MemoryDbClient : SdkClient {

    override val serviceName: String
        get() = "MemoryDB"
    /**
     * MemoryDbClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MemoryDbClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMemoryDbClient(config)
        }

        public operator fun invoke(config: Config): MemoryDbClient = DefaultMemoryDbClient(config)

        /**
         * Construct a [MemoryDbClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MemoryDbClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMemoryDbClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "MemoryDB")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see [Applying the service updates](https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates).
     */
    public suspend fun batchUpdateCluster(input: BatchUpdateClusterRequest): BatchUpdateClusterResponse

    /**
     * Makes a copy of an existing snapshot.
     */
    public suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Creates an Access Control List. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    public suspend fun createAcl(input: CreateAclRequest): CreateAclResponse

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see [Configuring engine parameters using parameter groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html).
     */
    public suspend fun createParameterGroup(input: CreateParameterGroupRequest): CreateParameterGroupResponse

    /**
     * Creates a copy of an entire cluster at a specific moment in time.
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see [Subnets and subnet groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html).
     */
    public suspend fun createSubnetGroup(input: CreateSubnetGroupRequest): CreateSubnetGroupResponse

    /**
     * Creates a MemoryDB user. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
     */
    public suspend fun deleteAcl(input: DeleteAclRequest): DeleteAclResponse

    /**
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.
     */
    public suspend fun deleteParameterGroup(input: DeleteParameterGroupRequest): DeleteParameterGroupResponse

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     */
    public suspend fun deleteSubnetGroup(input: DeleteSubnetGroupRequest): DeleteSubnetGroupResponse

    /**
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Returns a list of ACLs
     */
    public suspend fun describeAcLs(input: DescribeAcLsRequest = DescribeAcLsRequest {}): DescribeAcLsResponse

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.
     */
    public suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest {}): DescribeClustersResponse

    /**
     * Returns a list of the available Redis engine versions.
     */
    public suspend fun describeEngineVersions(input: DescribeEngineVersionsRequest = DescribeEngineVersionsRequest {}): DescribeEngineVersionsResponse

    /**
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.
     */
    public suspend fun describeParameterGroups(input: DescribeParameterGroupsRequest = DescribeParameterGroupsRequest {}): DescribeParameterGroupsResponse

    /**
     * Returns the detailed parameter list for a particular parameter group.
     */
    public suspend fun describeParameters(input: DescribeParametersRequest): DescribeParametersResponse

    /**
     * Returns details of the service updates
     */
    public suspend fun describeServiceUpdates(input: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest {}): DescribeServiceUpdatesResponse

    /**
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     */
    public suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest {}): DescribeSnapshotsResponse

    /**
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.
     */
    public suspend fun describeSubnetGroups(input: DescribeSubnetGroupsRequest = DescribeSubnetGroupsRequest {}): DescribeSubnetGroupsResponse

    /**
     * Returns a list of users.
     */
    public suspend fun describeUsers(input: DescribeUsersRequest = DescribeUsersRequest {}): DescribeUsersResponse

    /**
     * Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events, Amazon may block this API.
     */
    public suspend fun failoverShard(input: FailoverShardRequest): FailoverShardResponse

    /**
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.
     */
    public suspend fun listAllowedNodeTypeUpdates(input: ListAllowedNodeTypeUpdatesRequest): ListAllowedNodeTypeUpdatesResponse

    /**
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see [Tagging your MemoryDB resources](https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html)
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.
     */
    public suspend fun resetParameterGroup(input: ResetParameterGroupRequest): ResetParameterGroupResponse

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html).
     *
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Use this operation to remove tags on a resource
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Changes the list of users that belong to the Access Control List.
     */
    public suspend fun updateAcl(input: UpdateAclRequest): UpdateAclResponse

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.
     */
    public suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse

    /**
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    public suspend fun updateParameterGroup(input: UpdateParameterGroupRequest): UpdateParameterGroupResponse

    /**
     * Updates a subnet group. For more information, see [Updating a subnet group](https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html)
     */
    public suspend fun updateSubnetGroup(input: UpdateSubnetGroupRequest): UpdateSubnetGroupResponse

    /**
     * Changes user password(s) and/or access string.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see [Applying the service updates](https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates).
 */
public suspend inline fun MemoryDbClient.batchUpdateCluster(crossinline block: BatchUpdateClusterRequest.Builder.() -> Unit): BatchUpdateClusterResponse = batchUpdateCluster(BatchUpdateClusterRequest.Builder().apply(block).build())

/**
 * Makes a copy of an existing snapshot.
 */
public suspend inline fun MemoryDbClient.copySnapshot(crossinline block: CopySnapshotRequest.Builder.() -> Unit): CopySnapshotResponse = copySnapshot(CopySnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Access Control List. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
 */
public suspend inline fun MemoryDbClient.createAcl(crossinline block: CreateAclRequest.Builder.() -> Unit): CreateAclResponse = createAcl(CreateAclRequest.Builder().apply(block).build())

/**
 * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
 */
public suspend inline fun MemoryDbClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see [Configuring engine parameters using parameter groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html).
 */
public suspend inline fun MemoryDbClient.createParameterGroup(crossinline block: CreateParameterGroupRequest.Builder.() -> Unit): CreateParameterGroupResponse = createParameterGroup(CreateParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a copy of an entire cluster at a specific moment in time.
 */
public suspend inline fun MemoryDbClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see [Subnets and subnet groups](https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html).
 */
public suspend inline fun MemoryDbClient.createSubnetGroup(crossinline block: CreateSubnetGroupRequest.Builder.() -> Unit): CreateSubnetGroupResponse = createSubnetGroup(CreateSubnetGroupRequest.Builder().apply(block).build())

/**
 * Creates a MemoryDB user. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
 */
public suspend inline fun MemoryDbClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see [Authenticating users with Access Contol Lists (ACLs)](https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
 */
public suspend inline fun MemoryDbClient.deleteAcl(crossinline block: DeleteAclRequest.Builder.() -> Unit): DeleteAclResponse = deleteAcl(DeleteAclRequest.Builder().apply(block).build())

/**
 * Deletes a cluster. It also deletes all associated nodes and node endpoints
 */
public suspend inline fun MemoryDbClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.
 */
public suspend inline fun MemoryDbClient.deleteParameterGroup(crossinline block: DeleteParameterGroupRequest.Builder.() -> Unit): DeleteParameterGroupResponse = deleteParameterGroup(DeleteParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.
 */
public suspend inline fun MemoryDbClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
 */
public suspend inline fun MemoryDbClient.deleteSubnetGroup(crossinline block: DeleteSubnetGroupRequest.Builder.() -> Unit): DeleteSubnetGroupResponse = deleteSubnetGroup(DeleteSubnetGroupRequest.Builder().apply(block).build())

/**
 * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
 */
public suspend inline fun MemoryDbClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Returns a list of ACLs
 */
public suspend inline fun MemoryDbClient.describeAcLs(crossinline block: DescribeAcLsRequest.Builder.() -> Unit): DescribeAcLsResponse = describeAcLs(DescribeAcLsRequest.Builder().apply(block).build())

/**
 * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.
 */
public suspend inline fun MemoryDbClient.describeClusters(crossinline block: DescribeClustersRequest.Builder.() -> Unit): DescribeClustersResponse = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of the available Redis engine versions.
 */
public suspend inline fun MemoryDbClient.describeEngineVersions(crossinline block: DescribeEngineVersionsRequest.Builder.() -> Unit): DescribeEngineVersionsResponse = describeEngineVersions(DescribeEngineVersionsRequest.Builder().apply(block).build())

/**
 * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
 */
public suspend inline fun MemoryDbClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.
 */
public suspend inline fun MemoryDbClient.describeParameterGroups(crossinline block: DescribeParameterGroupsRequest.Builder.() -> Unit): DescribeParameterGroupsResponse = describeParameterGroups(DescribeParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns the detailed parameter list for a particular parameter group.
 */
public suspend inline fun MemoryDbClient.describeParameters(crossinline block: DescribeParametersRequest.Builder.() -> Unit): DescribeParametersResponse = describeParameters(DescribeParametersRequest.Builder().apply(block).build())

/**
 * Returns details of the service updates
 */
public suspend inline fun MemoryDbClient.describeServiceUpdates(crossinline block: DescribeServiceUpdatesRequest.Builder.() -> Unit): DescribeServiceUpdatesResponse = describeServiceUpdates(DescribeServiceUpdatesRequest.Builder().apply(block).build())

/**
 * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
 */
public suspend inline fun MemoryDbClient.describeSnapshots(crossinline block: DescribeSnapshotsRequest.Builder.() -> Unit): DescribeSnapshotsResponse = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.
 */
public suspend inline fun MemoryDbClient.describeSubnetGroups(crossinline block: DescribeSubnetGroupsRequest.Builder.() -> Unit): DescribeSubnetGroupsResponse = describeSubnetGroups(DescribeSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of users.
 */
public suspend inline fun MemoryDbClient.describeUsers(crossinline block: DescribeUsersRequest.Builder.() -> Unit): DescribeUsersResponse = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

/**
 * Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events, Amazon may block this API.
 */
public suspend inline fun MemoryDbClient.failoverShard(crossinline block: FailoverShardRequest.Builder.() -> Unit): FailoverShardResponse = failoverShard(FailoverShardRequest.Builder().apply(block).build())

/**
 * Lists all available node types that you can scale to from your cluster's current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.
 */
public suspend inline fun MemoryDbClient.listAllowedNodeTypeUpdates(crossinline block: ListAllowedNodeTypeUpdatesRequest.Builder.() -> Unit): ListAllowedNodeTypeUpdatesResponse = listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest.Builder().apply(block).build())

/**
 * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see [Tagging your MemoryDB resources](https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html)
 */
public suspend inline fun MemoryDbClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.
 */
public suspend inline fun MemoryDbClient.resetParameterGroup(crossinline block: ResetParameterGroupRequest.Builder.() -> Unit): ResetParameterGroupResponse = resetParameterGroup(ResetParameterGroupRequest.Builder().apply(block).build())

/**
 * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see [Resource-level permissions](https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html).
 *
 * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html).
 */
public suspend inline fun MemoryDbClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Use this operation to remove tags on a resource
 */
public suspend inline fun MemoryDbClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Changes the list of users that belong to the Access Control List.
 */
public suspend inline fun MemoryDbClient.updateAcl(crossinline block: UpdateAclRequest.Builder.() -> Unit): UpdateAclResponse = updateAcl(UpdateAclRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.
 */
public suspend inline fun MemoryDbClient.updateCluster(crossinline block: UpdateClusterRequest.Builder.() -> Unit): UpdateClusterResponse = updateCluster(UpdateClusterRequest.Builder().apply(block).build())

/**
 * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
 */
public suspend inline fun MemoryDbClient.updateParameterGroup(crossinline block: UpdateParameterGroupRequest.Builder.() -> Unit): UpdateParameterGroupResponse = updateParameterGroup(UpdateParameterGroupRequest.Builder().apply(block).build())

/**
 * Updates a subnet group. For more information, see [Updating a subnet group](https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html)
 */
public suspend inline fun MemoryDbClient.updateSubnetGroup(crossinline block: UpdateSubnetGroupRequest.Builder.() -> Unit): UpdateSubnetGroupResponse = updateSubnetGroup(UpdateSubnetGroupRequest.Builder().apply(block).build())

/**
 * Changes user password(s) and/or access string.
 */
public suspend inline fun MemoryDbClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
