// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



/**
 * Contains all of the attributes of a specific cluster.
 */
public class Cluster private constructor(builder: Builder) {
    /**
     * The name of the Access Control List associated with this cluster.
     */
    public val aclName: kotlin.String? = builder.aclName
    /**
     * The Amazon Resource Name (ARN) of the cluster.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
     */
    public val availabilityMode: aws.sdk.kotlin.services.memorydb.model.AzStatus? = builder.availabilityMode
    /**
     * The cluster's configuration endpoint
     */
    public val clusterEndpoint: aws.sdk.kotlin.services.memorydb.model.Endpoint? = builder.clusterEndpoint
    /**
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     */
    public val dataTiering: aws.sdk.kotlin.services.memorydb.model.DataTieringStatus? = builder.dataTiering
    /**
     * A description of the cluster
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Redis engine patch version used by the cluster
     */
    public val enginePatchVersion: kotlin.String? = builder.enginePatchVersion
    /**
     * The Redis engine version used by the cluster
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ID of the KMS key used to encrypt the cluster
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     */
    public val maintenanceWindow: kotlin.String? = builder.maintenanceWindow
    /**
     * The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The cluster's node type
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of shards in the cluster
     */
    public val numberOfShards: kotlin.Int? = builder.numberOfShards
    /**
     * The name of the parameter group used by the cluster
     */
    public val parameterGroupName: kotlin.String? = builder.parameterGroupName
    /**
     * The status of the parameter group used by the cluster, for example 'active' or 'applying'.
     */
    public val parameterGroupStatus: kotlin.String? = builder.parameterGroupStatus
    /**
     * A group of settings that are currently being applied.
     */
    public val pendingUpdates: aws.sdk.kotlin.services.memorydb.model.ClusterPendingUpdates? = builder.pendingUpdates
    /**
     * A list of security groups used by the cluster
     */
    public val securityGroups: List<SecurityGroupMembership>? = builder.securityGroups
    /**
     * A list of shards that are members of the cluster.
     */
    public val shards: List<Shard>? = builder.shards
    /**
     * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The Amazon Resource Name (ARN) of the SNS notification topic
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The SNS topic must be in Active status to receive notifications
     */
    public val snsTopicStatus: kotlin.String? = builder.snsTopicStatus
    /**
     * The status of the cluster. For example, Available, Updating, Creating.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The name of the subnet group used by the cluster
     */
    public val subnetGroupName: kotlin.String? = builder.subnetGroupName
    /**
     * A flag to indicate if In-transit encryption is enabled
     */
    public val tlsEnabled: kotlin.Boolean? = builder.tlsEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("aclName=$aclName,")
        append("arn=$arn,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityMode=$availabilityMode,")
        append("clusterEndpoint=$clusterEndpoint,")
        append("dataTiering=$dataTiering,")
        append("description=$description,")
        append("enginePatchVersion=$enginePatchVersion,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceWindow=$maintenanceWindow,")
        append("name=$name,")
        append("nodeType=$nodeType,")
        append("numberOfShards=$numberOfShards,")
        append("parameterGroupName=$parameterGroupName,")
        append("parameterGroupStatus=$parameterGroupStatus,")
        append("pendingUpdates=$pendingUpdates,")
        append("securityGroups=$securityGroups,")
        append("shards=$shards,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicStatus=$snsTopicStatus,")
        append("status=$status,")
        append("subnetGroupName=$subnetGroupName,")
        append("tlsEnabled=$tlsEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aclName?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityMode?.hashCode() ?: 0)
        result = 31 * result + (clusterEndpoint?.hashCode() ?: 0)
        result = 31 * result + (dataTiering?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enginePatchVersion?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfShards ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (parameterGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (pendingUpdates?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (shards?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicStatus?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (tlsEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (aclName != other.aclName) return false
        if (arn != other.arn) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityMode != other.availabilityMode) return false
        if (clusterEndpoint != other.clusterEndpoint) return false
        if (dataTiering != other.dataTiering) return false
        if (description != other.description) return false
        if (enginePatchVersion != other.enginePatchVersion) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceWindow != other.maintenanceWindow) return false
        if (name != other.name) return false
        if (nodeType != other.nodeType) return false
        if (numberOfShards != other.numberOfShards) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (parameterGroupStatus != other.parameterGroupStatus) return false
        if (pendingUpdates != other.pendingUpdates) return false
        if (securityGroups != other.securityGroups) return false
        if (shards != other.shards) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicStatus != other.snsTopicStatus) return false
        if (status != other.status) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (tlsEnabled != other.tlsEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Cluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Access Control List associated with this cluster.
         */
        public var aclName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster.
         */
        public var arn: kotlin.String? = null
        /**
         * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
         */
        public var availabilityMode: aws.sdk.kotlin.services.memorydb.model.AzStatus? = null
        /**
         * The cluster's configuration endpoint
         */
        public var clusterEndpoint: aws.sdk.kotlin.services.memorydb.model.Endpoint? = null
        /**
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
         */
        public var dataTiering: aws.sdk.kotlin.services.memorydb.model.DataTieringStatus? = null
        /**
         * A description of the cluster
         */
        public var description: kotlin.String? = null
        /**
         * The Redis engine patch version used by the cluster
         */
        public var enginePatchVersion: kotlin.String? = null
        /**
         * The Redis engine version used by the cluster
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ID of the KMS key used to encrypt the cluster
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         */
        public var maintenanceWindow: kotlin.String? = null
        /**
         * The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
         */
        public var name: kotlin.String? = null
        /**
         * The cluster's node type
         */
        public var nodeType: kotlin.String? = null
        /**
         * The number of shards in the cluster
         */
        public var numberOfShards: kotlin.Int? = null
        /**
         * The name of the parameter group used by the cluster
         */
        public var parameterGroupName: kotlin.String? = null
        /**
         * The status of the parameter group used by the cluster, for example 'active' or 'applying'.
         */
        public var parameterGroupStatus: kotlin.String? = null
        /**
         * A group of settings that are currently being applied.
         */
        public var pendingUpdates: aws.sdk.kotlin.services.memorydb.model.ClusterPendingUpdates? = null
        /**
         * A list of security groups used by the cluster
         */
        public var securityGroups: List<SecurityGroupMembership>? = null
        /**
         * A list of shards that are members of the cluster.
         */
        public var shards: List<Shard>? = null
        /**
         * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the SNS notification topic
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The SNS topic must be in Active status to receive notifications
         */
        public var snsTopicStatus: kotlin.String? = null
        /**
         * The status of the cluster. For example, Available, Updating, Creating.
         */
        public var status: kotlin.String? = null
        /**
         * The name of the subnet group used by the cluster
         */
        public var subnetGroupName: kotlin.String? = null
        /**
         * A flag to indicate if In-transit encryption is enabled
         */
        public var tlsEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Cluster) : this() {
            this.aclName = x.aclName
            this.arn = x.arn
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityMode = x.availabilityMode
            this.clusterEndpoint = x.clusterEndpoint
            this.dataTiering = x.dataTiering
            this.description = x.description
            this.enginePatchVersion = x.enginePatchVersion
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceWindow = x.maintenanceWindow
            this.name = x.name
            this.nodeType = x.nodeType
            this.numberOfShards = x.numberOfShards
            this.parameterGroupName = x.parameterGroupName
            this.parameterGroupStatus = x.parameterGroupStatus
            this.pendingUpdates = x.pendingUpdates
            this.securityGroups = x.securityGroups
            this.shards = x.shards
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicStatus = x.snsTopicStatus
            this.status = x.status
            this.subnetGroupName = x.subnetGroupName
            this.tlsEnabled = x.tlsEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.Endpoint] inside the given [block]
         */
        public fun clusterEndpoint(block: aws.sdk.kotlin.services.memorydb.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.clusterEndpoint = aws.sdk.kotlin.services.memorydb.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.ClusterPendingUpdates] inside the given [block]
         */
        public fun pendingUpdates(block: aws.sdk.kotlin.services.memorydb.model.ClusterPendingUpdates.Builder.() -> kotlin.Unit) {
            this.pendingUpdates = aws.sdk.kotlin.services.memorydb.model.ClusterPendingUpdates.invoke(block)
        }
    }
}
