// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



public class DescribeSnapshotsRequest private constructor(builder: Builder) {
    /**
     * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A Boolean value which if true, the shard configuration is included in the snapshot description.
     */
    public val showDetail: kotlin.Boolean? = builder.showDetail
    /**
     * A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotsRequest(")
        append("clusterName=$clusterName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("showDetail=$showDetail,")
        append("snapshotName=$snapshotName,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (showDetail?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSnapshotsRequest

        if (clusterName != other.clusterName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (showDetail != other.showDetail) return false
        if (snapshotName != other.snapshotName) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A Boolean value which if true, the shard configuration is included in the snapshot description.
         */
        public var showDetail: kotlin.Boolean? = null
        /**
         * A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest) : this() {
            this.clusterName = x.clusterName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.showDetail = x.showDetail
            this.snapshotName = x.snapshotName
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest = DescribeSnapshotsRequest(this)
    }
}
