// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model



/**
 * Represents a copy of an entire cluster as of the time when the snapshot was taken.
 */
public class Snapshot private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the snapshot.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The configuration of the cluster from which the snapshot was taken
     */
    public val clusterConfiguration: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration? = builder.clusterConfiguration
    /**
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     */
    public val dataTiering: aws.sdk.kotlin.services.memorydb.model.DataTieringStatus? = builder.dataTiering
    /**
     * The ID of the KMS key used to encrypt the snapshot.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the snapshot
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
     */
    public val source: kotlin.String? = builder.source
    /**
     * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("arn=$arn,")
        append("clusterConfiguration=$clusterConfiguration,")
        append("dataTiering=$dataTiering,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("source=$source,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dataTiering?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (arn != other.arn) return false
        if (clusterConfiguration != other.clusterConfiguration) return false
        if (dataTiering != other.dataTiering) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (source != other.source) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Snapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the snapshot.
         */
        public var arn: kotlin.String? = null
        /**
         * The configuration of the cluster from which the snapshot was taken
         */
        public var clusterConfiguration: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration? = null
        /**
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
         */
        public var dataTiering: aws.sdk.kotlin.services.memorydb.model.DataTieringStatus? = null
        /**
         * The ID of the KMS key used to encrypt the snapshot.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the snapshot
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
         */
        public var source: kotlin.String? = null
        /**
         * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Snapshot) : this() {
            this.arn = x.arn
            this.clusterConfiguration = x.clusterConfiguration
            this.dataTiering = x.dataTiering
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.source = x.source
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Snapshot = Snapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration] inside the given [block]
         */
        public fun clusterConfiguration(block: aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.clusterConfiguration = aws.sdk.kotlin.services.memorydb.model.ClusterConfiguration.invoke(block)
        }
    }
}
