// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.memorydb.model.DescribeSubnetGroupsResponse
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.SubnetGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeSubnetGroupsOperationDeserializer: HttpDeserialize<DescribeSubnetGroupsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSubnetGroupsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSubnetGroupsError(context, response)
        }
        val builder = DescribeSubnetGroupsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSubnetGroupsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSubnetGroupsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetGroupNotFoundFault" -> SubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSubnetGroupsOperationBody(builder: DescribeSubnetGroupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SUBNETGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetGroups"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SUBNETGROUPS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SUBNETGROUPS_DESCRIPTOR.index -> builder.subnetGroups =
                    deserializer.deserializeList(SUBNETGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<SubnetGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubnetGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
